#!/bin/python2
# Copyright (c) 2019 ZettaDB inc. All rights reserved.
# This source code is licensed under Apache 2.0 License,
# combined with Common Clause Condition 1.0, as detailed in the NOTICE file.

import json
import argparse

def gen_meta_json(args):
    nodes = []
    for addr in args.seeds.split(","):
        parts = addr.split(':')
        mip = parts[0]
        if len(parts) > 1:
            mport = int(parts[1])
        else:
            mport = 3306
        nodes.append({"ip": mip, "port": mport})
    mobj = {"nodes": nodes, 'saas': args.saas, 'version': args.version}
    f = open('meta.json', 'w')
    json.dump(mobj, f, indent=4)
    f.close()

if  __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Specify the arguments.')
    parser.add_argument('--seeds', type=str, help="The meta seeds", required=True)
    parser.add_argument('--saas', type=int, help="the saas type", default=0)
    parser.add_argument('--version', type=str, help="the version", default="1.3.3")

    args = parser.parse_args()
    gen_meta_json(args)
