<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Echarts extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->config->load('myconfig');
		$this->key = $this->config->item('key');
		$this->post_url = $this->config->item('post_url');
	}
	public function getSlowLogCount()
	{
		$ip = $this->input->get('ip');
		$port = $this->input->get('port');
		$start_time = $this->input->get('start_time');
		$end_time = $this->input->get('end_time');
		//先获取prometheus的主节点，如果超过一百条数据，则不给到es查数据，如果没超过就直接到es上取慢查询的日志
		//默认显示1天的慢查询日志数
		//24h的CPU使用率（5m）
		//获取现在的时间
//		$current_time = date('Y-m-d H:i:s',time());
//		//往前推24小时
//		$new_time = strtotime("-0 hours", strtotime($current_time));
//		$result = date('Y-m-d H:i:s', $new_time);
		//获取prometheus主节点
		$this->load->model('Cluster_model');
		$sql = "select hostaddr,prometheus_port from kunlun_metadata_db.cluster_mgr_nodes where member_state='source' ";
		$res = $this->Cluster_model->getList($sql);
		//获取prometheus的node_exporter端口
		$sql = "select nodemgr_prometheus_port from kunlun_metadata_db.server_nodes where hostaddr='$ip' limit 1 ";
		$res_port = $this->Cluster_model->getList($sql);
		$slow_list=[];
		$cpu_list=[];
		$type_list=[];
		if(!empty($res)){
			$host=$this->Cluster_model->ipTranslation($res[0]['hostaddr']);
			$nums=12;//分成12等分
			$start = strtotime($start_time);
			$end   = strtotime($end_time);
			$parts = ($end - $start)/$nums;
			$last  = ($end - $start)%$nums;
			if ( $last > 0) {
				$parts = ($end - $start - $last)/$nums;
			}
			for ($i=1; $i <= $nums; $i++) {
				$_end  = $start + $parts * $i;
				$arr[] = array($start + $parts * ($i-1), $_end);
			}
			$len = count($arr)-1;
			$arr[$len][1] = $arr[$len][1] + $last;
			foreach ($arr as $key => $value) {
				//慢查询数
				$new_end_time= date('Y-m-d H:i:s', $value[1]);
				$type_list[]=$new_end_time;
				$slow_date= array(
					'query' => 'mysql_global_status_slow_queries{instance="'.$ip.':'.($port+1).'",job="mysql"}',
					'time' => $arr[$key][1]
				);
				$url='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($slow_date);
				$resp = $this->Cluster_model->getData($url);
				$resp=json_decode($resp, true);
				$slow_value='0';
				if(!empty($resp['data']['result'])){
					$slow_value=$resp['data']['result'][0]['value'][1];
				}
				$slow_list[]=$slow_value;
				//cpu使用率
				$cpu_date= array(
					'query' => '100 * (1 - sum by (instance)(increase(node_cpu_seconds_total{ instance="'.$ip.':'.$res_port[0]['nodemgr_prometheus_port'].'",job="node",mode="idle"}[5m])) /sum by (instance)(increase(node_cpu_seconds_total[5m])))',
					'time' => $arr[$key][1]
				);
				$url1='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($cpu_date);
				$resp_cpu = $this->Cluster_model->getData($url1);
				$cpu_res=json_decode($resp_cpu,true);
				$cpu_value='0';
				if(!empty($cpu_res['data']['result'])){
					$cpu_v=$cpu_res['data']['result'][0]['value'][1];
					$cpu_value=number_format($cpu_v, 2);
				}
				$cpu_list[]=$cpu_value;
			}
//			foreach ($segments as $segment) {
////				echo "从 " . $segment['start'] . " 到 " . $segment['end'] . "\n";
//				print_r($segment['start']);exit;
//				$new_end_time= date('Y-m-d H:i:s', $segment['end']);
//				$type_list[]=$new_end_time;
//				$slow_date= array(
//					'query' => 'mysql_global_status_slow_queries{instance="'.$ip.':'.($port+1).'",job="mysql"}',
//					'start' => strtotime($segment['start']),
//					'end' => strtotime($segment['end'])
//				);
//				$url='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($slow_date);
//				$resp = $this->Cluster_model->getData($url);
//				$resp=json_decode($resp, true);
//				$slow_value='0';
//				if(!empty($resp['data']['result'])){
//					$slow_value=$resp['data']['result'][0]['value'][1];
//				}
//				$slow_list[]=$slow_value;
//				//cpu使用率
//				$cpu_date= array(
//					'query' => '100 * (1 - sum by (instance)(increase(node_cpu_seconds_total{ instance="'.$ip.':'.$res_port[0]['nodemgr_prometheus_port'].'",job="node",mode="idle"}[5m])) /sum by (instance)(increase(node_cpu_seconds_total[5m])))',
//					'start' => strtotime($segment['start']),
//					'end' => strtotime($segment['end'])
//				);
//				$url1='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($cpu_date);
//				$resp_cpu = $this->Cluster_model->getData($url1);
//				$cpu_res=json_decode($resp_cpu,true);
//				$cpu_value='0';
//				if(!empty($cpu_res['data']['result'])){
//					$cpu_v=$cpu_res['data']['result'][0]['value'][1];
//					$cpu_value=number_format($cpu_v, 2);
//				}
//				$cpu_list[]=$cpu_value;
//				$start_time=$new_end_time;
//			}
			/*for($i=0;$i<12;$i++){
				$new_start_time =  strtotime( "-2 hours",strtotime($start_time));
				$new_end_time= date('Y-m-d H:i:s', $new_start_time);
				$type_list[]=$new_end_time;
				$slow_date= array(
					'query' => 'mysql_global_status_slow_queries{instance="'.$ip.':'.($port+1).'",job="mysql"}',
					'start' => strtotime($start_time),
					'end' => $new_start_time
				);
				$url='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($slow_date);
				$resp = $this->Cluster_model->getData($url);
				$resp=json_decode($resp, true);
				$slow_value='-1';
				if(!empty($resp['data']['result'])){
					$slow_value=$resp['data']['result'][0]['value'][1];
				}
				$slow_list[]=$slow_value;
				//cpu使用率
				$cpu_date= array(
					'query' => '100 * (1 - sum by (instance)(increase(node_cpu_seconds_total{ instance="'.$ip.':'.$res_port[0]['nodemgr_prometheus_port'].'",job="node",mode="idle"}[5m])) /sum by (instance)(increase(node_cpu_seconds_total[5m])))',
					'start' => strtotime($start_time),
					'end' => $new_start_time
				);
				$url1='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($cpu_date);
				$resp_cpu = $this->Cluster_model->getData($url1);
				$cpu_res=json_decode($resp_cpu,true);
				$cpu_value='0';
				if(!empty($cpu_res['data']['result'])){
					$cpu_v=$cpu_res['data']['result'][0]['value'][1];
					$cpu_value=number_format($cpu_v, 2);
				}
				$cpu_list[]=$cpu_value;
				$start_time=$new_end_time;
			}*/
		}
		$data['type_list']=$type_list;
		$data['slow_list']=$slow_list;
		$data['cpu_list']=$cpu_list;
		print_r(json_encode($data));
	}
	public function getThisSlowLogCount()
	{
		//先获取prometheus的主节点，如果超过一百条数据，则不给到es查数据，如果没超过就直接到es上取慢查询的日志
		$ip = $this->input->get('ip');
		$port = $this->input->get('port');
		$start_time = $this->input->get('start_time');
		$end_time = $this->input->get('end_time');
		//获取prometheus主节点
		$this->load->model('Cluster_model');
		$sql = "select hostaddr,prometheus_port from cluster_mgr_nodes where member_state='source' ";
		$res = $this->Cluster_model->getList($sql);
		$slow_list=[];
		if(!empty($res)){
			$host=$this->Cluster_model->ipTranslation($res[0]['hostaddr']);
			//慢查询数
			$slow_date= array(
				'query' => 'mysql_global_status_slow_queries{instance="'.$ip.':'.($port+1).'",job="mysql"}',
				'start' => strtotime($start_time),
				'end' => strtotime($end_time)
			);
			$url='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($slow_date);
			$resp = $this->Cluster_model->getData($url);
			$resp=json_decode($resp, true);
			$slow_value='0';
			if(!empty($resp['data']['result'])){
				$slow_value=$resp['data']['result'][0]['value'][1];
			}
			$slow_list[]=$slow_value;
		}
		$data['slow_total']=$slow_list;
		print_r(json_encode($data));
	}
	public function getTransactionCount()
	{
		$ip = $this->input->get('ip');
		$port = $this->input->get('port');
		$start_time = $this->input->get('start_time');
		$end_time = $this->input->get('end_time');
		//获取prometheus主节点
		$this->load->model('Cluster_model');
		$sql = "select hostaddr,prometheus_port from cluster_mgr_nodes where member_state='source' ";
		$res = $this->Cluster_model->getList($sql);
		$slow_list=[];
		$qps_list=[];
		$type_list=[];
		$tps_list=[];
		if(!empty($res)){
			$host=$this->Cluster_model->ipTranslation($res[0]['hostaddr']);
			$nums=12;//分成12等分
			$start = strtotime($start_time);
			$end   = strtotime($end_time);
			$parts = ($end - $start)/$nums;
			$last  = ($end - $start)%$nums;
			if ( $last > 0) {
				$parts = ($end - $start - $last)/$nums;
			}
			for ($i=1; $i <= $nums; $i++) {
				$_end  = $start + $parts * $i;
				$arr[] = array($start + $parts * ($i-1), $_end);
			}
			$len = count($arr)-1;
			$arr[$len][1] = $arr[$len][1] + $last;
			foreach ($arr as $key => $value) {
				//回滚事务数量
				$new_end_time= date('Y-m-d H:i:s', $value[1]);
				$type_list[]=$new_end_time;
				$slow_date= array(
					'query' => 'mysql_global_status_handlers_total{instance="'.$ip.':'.($port+1).'",job="mysql",handler="savepoint_rollback"}',
					'time' => $arr[$key][1]
				);
				$url='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($slow_date);
				$resp = $this->Cluster_model->getData($url);
				$resp=json_decode($resp, true);
				$slow_value='0';
				if(!empty($resp['data']['result'])){
					$slow_value=$resp['data']['result'][0]['value'][1];
				}
				$slow_list[]=$slow_value;
				//QPS
				$cpu_date= array(
					'query' => 'mysql_global_status_queries{job="mysql",instance="'.$ip.':'.($port+1).'"}/mysql_global_status_uptime{instance="'.$ip.':'.($port+1).'",job="mysql"}',
					'time' => $arr[$key][1]
				);
				$url1='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($cpu_date);
				$resp_cpu = $this->Cluster_model->getData($url1);
				$cpu_res=json_decode($resp_cpu,true);
				$cpu_value='0';
				if(!empty($cpu_res['data']['result'])){
					$cpu_v=$cpu_res['data']['result'][0]['value'][1];
					$cpu_value=number_format($cpu_v, 4);
				}
				$qps_list[]=$cpu_value;
				//TPS
				$tps_date= array(
					'query' => '(sum(rate(mysql_global_status_commands_total{command="rollback",job="mysql",instance="'.$ip.':'.($port+1).'"}[5m]))+sum(rate(mysql_global_status_commands_total{command="commit",job="mysql",instance="'.$ip.':'.($port+1).'"}[5m])))/sum(rate(mysql_global_status_uptime{instance="'.$ip.':'.($port+1).'",job="mysql"}[5m]))',
					'time' => $arr[$key][1]
				);
				$url2='http://'.$host.':'.$res[0]['prometheus_port'].'/api/v1/query?'.http_build_query($tps_date);
				$resp_tps = $this->Cluster_model->getData($url2);
				$tps_res=json_decode($resp_tps,true);
				$tps_value='0';
				if(!empty($tps_res['data']['result'])){
					$tps_v=$tps_res['data']['result'][0]['value'][1];
					$tps_value=$tps_v;
				}
				$tps_list[]=$tps_value;
			}
		}
		$data['type_list']=$type_list;
		$data['slow_list']=$slow_list;
		$data['qps_list']=$qps_list;
		$data['tps_list']=$tps_list;
		print_r(json_encode($data));
	}
}
