<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Stream extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->config->load('myconfig');
        $this->key = $this->config->item('key');
        $this->post_url = $this->config->item('post_url');

        $this->load->model('Login_model');
        $this->load->model('Cluster_model');
        $this->load->model('Stream_model');
        $this->load->model('Stream_recover_model');

    }


    public function getMeta($ip, $port)
    {
        $sql = "select hostaddr,port from cluster_mgr_nodes where member_state='source'";
        $this->load->model('Change_model');
        $res = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql);
        return $res;
    }


    public function getShardInfo($ips_arr)
    {
        $ip_arr = explode(',', $ips_arr);
        foreach ($ip_arr as $knode => $vnode) {

            $meta_arr = explode(':', $vnode);
            $res_meta = $this->getMeta($meta_arr[0], $meta_arr[1]);
            if ($res_meta['code'] == 200) {
                $cluster_sql = "select * from db_clusters where when_deleted is null ";
                $res_main = $this->Change_model->getMysql($meta_arr[0], $meta_arr[1], 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $cluster_sql);
                $shard_sql = "select * from shard_nodes where when_deleted is null and  db_cluster_id=" . $res_main[0] . " and member_state='source'";
                $shards_main = $this->Change_model->getMysql($meta_arr[0], $meta_arr[1], 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $shard_sql);
                $get_gtid_sql = "show master status";
                $shards_master = $this->Change_model->getMysql($shards_main[2], $shards_main[3], 'pgx', 'pgx_pwd', '', $get_gtid_sql);
                $shard_parms = [
                    [
                        "shard_id" => $shards_main[6],
                        "dump_hostaddr" => $shards_main[2],
                        "dump_port" => $shards_main[3],
                        "binlog_file" => $shards_master[0],
                        "binlog_pos" => $shards_master[1],
                        "gtid_set" => $shards_master[4],
                    ]
                ];
                return $shard_parms;
            }
        }
    }


    private function getRcrInfo($rcr_id)
    {
        $sql = "select * from cluster_rcr_infos where id =? and status!='deleted'";
        $result = $this->Cluster_model->getList($sql, [$rcr_id]);

        foreach ($result as $key => $row) {
            $result[$key]['master_shard_info'] = $this->getShardInfo($row['master_rcr_meta']);
            $result[$key]['slave_shard_info'] = $this->getShardInfo($row['slave_rcr_meta']);
        }

        return $result;
    }

    public function getStreamList()
    {

        $conditions = []; // 这里可以根据需要设置条件
        $limit = $this->input->get('pageSize') ? intval($this->input->get('pageSize')) : 10;
        $offset = $this->input->get('pageNo') ? intval($this->input->get('pageNo')) : 0;

        $offset = ($offset - 1) * $limit;
        $result = $this->Cluster_model->getClusterSteamTask($conditions, $limit, $offset);

        foreach ($result as $key => &$value) {

            $value['create_at'] = date('Y-m-d H:i:s', $value['create_at']);
            $value['update_at'] = date('Y-m-d H:i:s', $value['update_at']);
            $value['source_data_info'] = json_decode($value['source_data_info'], true);

            $value['task_params'] = json_decode($value['task_params'], true);
            $value['rcr_info'] = $this->getRcrInfo($value['rcr_id']);
            $value['cdc_src_info'] = $this->getCdcInfo($value['cdc_src']);
            $value['cdc_dst_info'] = $this->getCdcInfo($value['cdc_dst']);

            $value['cdc_src_created_info'] = $this->getCdcCreatedInfo($value['cdc_src']);
            $value['cdc_dst_created_info'] = $this->getCdcCreatedInfo($value['cdc_dst']);

        }
        unset($value);

        // 返回结果
        $data['code'] = 200;
        $data['list'] = $result;
        $data['total'] = count($result); // 根据实际需求设置总记录数
        print_r(json_encode($data));

    }


    /**
     * @return mixed
     */
    public function getCdcInfo($cdc_job_id)
    {

        $res = $this->Cluster_model->getList("select * from cluster_cdc_worker where delete_time IS NULL and job_id=? and job_name is not null",
			[$cdc_job_id]);
        if ($res) {
            foreach ($res as $key => &$v) {
                $v['worker_param'] = json_decode($v['worker_param'], true);
            }
        }
        unset($v);
        return $res;
    }


    /**
     * @return mixed
     */
    public function getCdcCreatedInfo($cdc_job_id)
    {

        $updata_sql = "select * from cluster_general_job_log  where `job_type`=? and `job_id`=? order by id desc limit 1";


        $res = $this->Cluster_model->getList($updata_sql, ['add_cdc_worker_list', $cdc_job_id]);

       // pa([$updata_sql,['add_cdc_worker_list', $cdc_job_id],$res]);

        $res[0]['job_info'] = json_decode($res[0]['job_info'], true);

        foreach ($res[0]['job_info']['paras']['output_plugins'] as $key => &$value) {
            $value['plugin_param'] = json_decode($value['plugin_param'], true);
        }
        unset($value);
        return $res;

    }


    public function updateStream()
    {
        //获取token
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }

        // 获取请求中的 JSON 数据
        $inputData = json_decode(@file_get_contents('php://input'), true);
        
        $id = $inputData['id'];
        $task_name = $inputData['export_name']; 
        $taskId = $inputData['export_id'];
        $rcr_id = $inputData['rcr_id'];
        
        // 更新数据
        $sql = "UPDATE cluster_steams SET task_name = ?, rcr_id = ?, task_params = ?, update_at = ? WHERE id = ?";
        $params = [
            $task_name,
            $rcr_id,
            json_encode($inputData),
            time(),
            $id
        ];
        
        // 执行更新
        $this->load->model('Cluster_model');
        $result = $this->Cluster_model->updateList($sql, $params);
        
        // 返回结果
        if ($result) {
            $data['code'] = 200;
            $data['message'] = '更新成功';
            $data['data'] = $result;
        } else {
            $data['code'] = 500;
            $data['message'] = '更新失败';
        }
        
        print_r(json_encode($data));
    }

    public function deleteStream()
    {
        //获取token
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }

        $this->load->model('Cluster_model');
        // 获取请求中的 JSON 数据
        $inputData = json_decode(@file_get_contents('php://input'), true);
        $id = $inputData['paras']['name'];
        $cdc_src_info = $inputData['paras']['cdc_src'];
        $params = $cdc_src_info[0]['job_info']['paras'];
        if (count($cdc_src_info) > 1) {
            $this->load->model('Cdc_model');
            if ($params['output_plugins'][0]['plugin_name'] == 'consistent_sql') {
                $shard_parms = $params['shard_params'][0];
                $plugin_param = $params['output_plugins'][0]['plugin_param'];
                $drop_table_sql = "drop table {$shard_parms['binlog_file']}.{$shard_parms['binlog_pos']}";
                $this->Cdc_model->getMysqlNullDb($plugin_param['hostaddr'], $plugin_param['port'], $plugin_param['user'], $plugin_param['password'], $shard_parms['binlog_file'], $drop_table_sql);
            }
        }

        $result = $this->Cluster_model->updateList("delete from cluster_steams where id=?", [$id]);

        if ($result) {

            $this->load->model('ClusterLog_model');

            $params = ['', '', 'delete_stream', 'done', json_encode($result),
                date("Y-m-d H:i:s", time()),
                date("Y-m-d H:i:s", time()),
                json_encode($inputData),
                ''
            ];

            $this->ClusterLog_model->clusterGeneralJobLog($params);

            $data['code'] = 200;
            $data['message'] = '删除成功';
            $data['data'] = json_encode($result);
            print_r(json_encode($data));
        } else {
            $data['code'] = 500;
            $data['message'] = '删除失败';
            $data['data'] = json_encode($result);
            print_r(json_encode($data));
        }
    }


    public function createStream()
    {

        // 获取请求中的 JSON 数据
        $inputData = json_decode(@file_get_contents('php://input'), true);


        $id = $inputData['id'];
        $task_name = $inputData['export_name']; // 确保 status 是整数
        $createAt = isset($inputData['create_at']) ? intval($inputData['create_at']) : time(); // 确保 create_at 是整数
        $taskId = $inputData['export_id'];
        $rcr_id = $inputData['rcr_id'];
        $cdc_src = 0;
        $cdc_dst = 0;
        $sql = "SELECT * FROM cluster_steams WHERE task_id = ?";
        $result = $this->Cluster_model->getList($sql, [$taskId]);
        if ($result) {
            $data['code'] = 500;
            $data['message'] = '任务已存在';
            print_r(json_encode($data));
            exit;
        }

        if ($id == 0) {
            $sql = "INSERT INTO cluster_steams(`rcr_id`, `cdc_src`, `cdc_dst`, `status`, `create_at`, `task_id`, `task_name`, `task_params`) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $params = [
                $rcr_id,
                $cdc_src,
                $cdc_dst,
                1,
                $createAt,
                $taskId,
                $task_name,
                json_encode($inputData)
            ];
            // 执行更新
            $result = $this->Cluster_model->updateList($sql, $params);

        } else {
            //更新数据
        }
        // 返回结果
        if ($result) {
            $data['code'] = 200;
            $data['message'] = '任务添加成功';
        } else {
            $data['code'] = 500;
            $data['message'] = '任务添加失败';
        }

        print_r(json_encode($data));
    }


    public function editMachine()
    {
        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        //调接口
        $this->load->model('Cluster_model');
        $post_data = str_replace("\\/", "/", json_encode($string));
        $post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
        $post_arr = json_decode($post_arr, TRUE);
        $data = $post_arr;
        print_r(json_encode($data));
    }


    public function RecoverStream()
    {

        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }

        // 获取请求中的 JSON 数据
        $inputData = json_decode(@file_get_contents('php://input'), true);



        $type = $inputData['type'];
        $stream_id = $inputData['stream_id'];
        $src_id = $inputData['src_id'];
        $dst_id = $inputData['dst_id'];

        $get_stream_recv = "select * from cluster_steams_recover where stream_id=? order by id desc limit 1";

        $stream_recv = $this->Stream_recover_model->getList($get_stream_recv, [$stream_id]);

        $params_post = $inputData['params'];
        $cdc_group_name = $inputData['cdc_group'];
        $do_update = $inputData['update'];
        $rcr_build = $inputData['rcr_build'];
        $this->load->model('Cdc_model');
        $this->load->model('Cluster_model');
        $job_rb_id = "";
        if ($do_update == 0) {

            switch ($type) {
                case "delete_cdc_src":
                    $delete_src_response = $this->Cdc_model->delete_cdc_worker_task($src_id, $cdc_group_name, $params_post);
                    $job_rb_id = $delete_src_response['job_id'];
                    break;

                case "delete_cdc_dst":
                    $delete_dst_response = $this->Cdc_model->delete_cdc_worker_task($dst_id, $cdc_group_name, $params_post);
                    $job_rb_id = $delete_dst_response['job_id'];
                    break;

                case "rb_create_cdc_src":

                    log_message('debug', '=== rb_create_cdc_src 开始处理 ===');
                    log_message('debug', 'cdc_group_name: ' . $cdc_group_name);
                    log_message('debug', '原始params_post: ' . json_encode($params_post));

                    $hot_switch = $params_post['hot_switch'];
                    $job_name = $params_post['job_name'];
                    $src_db_type = $params_post['src_db_type'];
                    $dst_db_type = $params_post['dst_db_type'];
                    $db_cluster_id = $params_post['db_cluster_id'];
                    $is_proxy_sql = $params_post['is_proxy_sql'];

                    log_message('debug', '提取的参数 - hot_switch: ' . $hot_switch . ', job_name: ' . $job_name . ', src_db_type: ' . $src_db_type . ', dst_db_type: ' . $dst_db_type . ', db_cluster_id: ' . $db_cluster_id . ', is_proxy_sql: ' . $is_proxy_sql);

                    unset($params_post['hot_switch']);
                    unset($params_post['job_name']);
                    unset($params_post['src_db_type']);
                    unset($params_post['dst_db_type']);
                    unset($params_post['db_cluster_id']);
                    unset($params_post['is_proxy_sql']);

                    log_message('debug', '清理后的params_post: ' . json_encode($params_post));
                    log_message('debug', '准备调用 add_cdc_worker_list 方法');

                    $src_response = $this->Cdc_model->add_cdc_worker_list($cdc_group_name, $params_post,true);
                    
                    log_message('debug', 'add_cdc_worker_list 返回结果: ' . json_encode($src_response));
                    
                    if (isset($src_response['job_id'])) {
                        $job_rb_id = $src_response['job_id'];
                        log_message('debug', '成功获取job_id: ' . $job_rb_id);
                    } else {
                        log_message('error', 'add_cdc_worker_list 返回结果中没有job_id字段!');
                        log_message('error', '完整返回结果: ' . json_encode($src_response));
                        $job_rb_id = null;
                    }

                    log_message('debug', '最终job_rb_id值: ' . ($job_rb_id ? $job_rb_id : 'NULL'));

					try {

						$insert_sql = "insert into cluster_cdc_worker(create_time,group_name,job_name,src_db_type,dst_db_type,db_cluster_id,is_proxy_sql,job_id) values (?,?,?,?,?,?,?,?)";

						$params = [
							time(),
							$cdc_group_name,
							$job_name,
							$src_db_type,
							$dst_db_type,
							$db_cluster_id,
							$is_proxy_sql,
							$job_rb_id
						];
                        
                        log_message('debug', '准备插入cluster_cdc_worker表，SQL: ' . $insert_sql);
                        log_message('debug', '插入参数: ' . json_encode($params));
                        
						$insert_result = $this->Cluster_model->updateList($insert_sql, $params);
                        log_message('debug', '插入结果: ' . json_encode($insert_result));
                        
					}catch (Exception $e) {

						log_message('error', '===add_cdc_worker_list error - 执行插入SQL: ' . $insert_sql."-插入参数: "
							.json_encode($params)."===".$e->getMessage());

					}

                    if ($hot_switch == "1") {
                        log_message('debug', '处理热切换逻辑，hot_switch = 1');

                        $insert_sql = "INSERT INTO `cluster_cdc_hot_switch` (`cdc_job_id`,`switch_params`) VALUES (?,?)";
                        $params = [
                            $src_response['job_id'],
                            json_encode($params_post)
                        ];
                        
                        log_message('debug', '插入热切换记录，SQL: ' . $insert_sql);
                        log_message('debug', '热切换参数: ' . json_encode($params));
                        
                        $hot_switch_result = $this->Cluster_model->updateList($insert_sql, $params);
                        log_message('debug', '热切换插入结果: ' . json_encode($hot_switch_result));
                    }

                    log_message('debug', '=== rb_create_cdc_src 处理完成 ===');
                    break;

                case "rb_create_cdc_dst":

                    $dst_response = $this->Cdc_model->add_cdc_worker_list($cdc_group_name, $params_post);
                    $job_rb_id = $dst_response['job_id'];

                    break;

                case "delete_rcr":

                    //判断rcr 是在哪个机器上创建的，在哪个机器创建的，就在哪个机器删除

                    $delete_mgr_http_url = $this->Cluster_model->getClusterMgrHttp($rcr_build);

                    $post_data = str_replace("\\/", "/", json_encode($params_post));
                    $post_arr = $this->Cluster_model->postData($post_data, $delete_mgr_http_url);
                    $post_arr = json_decode($post_arr, TRUE);
                    if ($post_arr['status'] === 'accept') {
                        $job_rb_id = $post_arr['job_id'];
                    }
                    // 更新状态
                    break;

                case "rb_create_rcr":

                    $meta_host = $params_post['paras']['slave_rcr_meta'];
                    $mgr_http_url = $this->Cluster_model->getClusterMgrHttp($meta_host);
                    $post_data = str_replace("\\/", "/", json_encode($params_post));
                    $post_arr = $this->Cluster_model->postData($post_data, $mgr_http_url);
                    $post_arr = json_decode($post_arr, TRUE);

                    if ($post_arr['status'] === 'accept') {
                        $job_rb_id = $post_arr['job_id'];
                    }
                    break;

                case "check_src_dst_num":

                    $data['code'] = 200;
                    $job_rb_id = "110119120";
                    $data['job_id'] = $job_rb_id;
                    $data['message'] = '恢复成功';
                    print_r(json_encode($data));
                    return;
                    break;

                default:

            }
        }

        if ($stream_recv && $stream_recv[0]['status'] == 0) {

            $now_param = json_encode($inputData['now_params']);
            $time = time() + rand(0, 9);
            // 使用参数化查询
            $update_sql = "update cluster_steams_recover set status=?,now_params=?,update_at=? where id=?";
            $params = ['0', $now_param, $time, 7];
            
            // 然后在调用updateList时传递参数
            $res = $this->Stream_recover_model->updateList($update_sql, $params);
            if ($res) {
                $data['job_id'] = $job_rb_id;
                $data['code'] = 200;
                $data['message'] = '恢复成功';
            } else {
                $data['code'] = 500;
                $data['message'] = '恢复失败';
                $data['err_message1'] = $res;
                $data['err_message2'] = $update_sql;
            }

        } else {
            $insert_sql = "insert into cluster_steams_recover(`stream_id`,`status`,`create_at`,`prv_params`,`now_params`) values(?,?,?,?,?)";
            $params = [
                $stream_id,
                0,
                time(),
                json_encode($inputData['prv_params']),
                json_encode($inputData['now_params'])
            ];
            $res = $this->Stream_recover_model->updateList($insert_sql, $params);
            if ($res && $res['data']['affected_rows'] == 1) {
                $data['job_id'] = $job_rb_id;
                $data['code'] = 200;
                $data['message'] = '恢复成功';
            } else {
                $data['code'] = 500;
                $data['message'] = '恢复失败';
                $data['err_message2'] = $res;
            }
        }

        print_r(json_encode($data));
    }


    /**
     * 更新cluster_steams cdc src or cdc dst
     * @return string
     */
    public function updateSteamCdc()
    {
        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }

        // 获取请求中的 JSON 数据
        $inputData = json_decode(@file_get_contents('php://input'), true);

        $stream_id = $inputData['stream_id'];
        $cdc_src = $inputData['cdc_src'];

        $type = $inputData['type'];

        $this->load->model('Stream_model');
        if ($type === 'rb_create_cdc_src') {

            $res = $this->Stream_model->updateList("update cluster_steams set cdc_src=? where id=?", [$cdc_src, $stream_id]);
            log_message('error', 'updateList: ' . json_encode($res));
        }

        if ($type === 'rb_create_cdc_dst') {
            $res = $this->Stream_model->updateList("update cluster_steams set cdc_dst=? where id=?", [$cdc_src, $stream_id]);
            log_message('error', 'updateList: ' . json_encode($res));
        }

        $data['code'] = 200;
        $data['message'] = 'ok';
        print_r(json_encode($data));
        return;
    }

    public function getMetaDbTypeInfo()
    {
        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }

        // 获取请求中的 JSON 数据
        $inputData = json_decode(@file_get_contents('php://input'), true);

        $db_type = $inputData['db_type'];

        $db_pass = $inputData['db_pass'];
        $db_host = $inputData['db_host'];

        $db_name = $inputData['db_name'];
        $db_table = $inputData['db_table'];

        switch ($db_type) {
            case "kunlunbase":
                $db_info = $this->getKunlunDbInfo($db_host, $db_name, $db_table, $db_pass);
                if ($db_info) {
                    $data['code'] = 200;
                    $data['message'] = '获取成功';
                    $data['data'] = $db_info;
                } else {
                    $data['code'] = 201;
                    $data['message'] = '获取失败';
                }
                print_r(json_encode($data));
                break;
            case 'mongodb':

                $db_info = $this->getMongoDbInfo($db_host, $db_name, $db_table, $db_pass);

                if ($db_info) {
                    $data['code'] = 200;
                    $data['message'] = '获取成功';
                    $data['data'] = $db_info;
                } else {
                    $data['code'] = 201;
                    $data['message'] = '获取失败';
                }

                print_r(json_encode($data));
                break;
        }

    }

    private function getMongoDbInfo($db_host, $db_name, $db_table, $db_pass)
    {
        $this->load->model('Mongodb_model');
        $db_host = str_replace('mongodb://', '', $db_host);
        return $this->Mongodb_model->get_db_list_max_id($db_host, $db_name);

    }

    private function getKunlunDbInfo($db_host, $db_name = "", $db_table = "", $db_pass = ""): array
    {


        //验证元数据ip端口是否能通
        $ips_arr = explode(',', $db_host);

        $comp_meta_info = [];
        foreach ($ips_arr as $knode => $vnode) {
            $meta_arr = explode(':', $vnode);

            $res_meta = $this->getMeta($meta_arr[0], $meta_arr[1]);
            if ($res_meta['code'] == 200) {

                $cluster_sql = "select * from db_clusters where when_deleted is null ";
                $res_main = $this->Change_model->getMysql($meta_arr[0], $meta_arr[1], 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $cluster_sql);

                $comp_nods_sql = "select * from comp_nodes where db_cluster_id={$res_main[0]} ";

                $comp_meta = $this->Change_model->getMysql($meta_arr[0], $meta_arr[1], 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $comp_nods_sql);

                $comp_meta_info = [
                    [
                        "cluster_name" => $res_main[1],
                        "hostaddr" => $comp_meta[2],
                        "port" => $comp_meta[4],
                        "user_name" => $comp_meta[6],
                        "user_passwd" => $comp_meta[7],
                    ]
                ];

                break;
            }
        }

        return $comp_meta_info;

    }


    public function getCdcStateInfo()
    {
        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }

        // 获取请求中的 JSON 数据
        $inputData = json_decode(@file_get_contents('php://input'), true);

        $job_id = $inputData['job_id'];

        $host = $inputData['cluster_slave_mate'];

        $sql = "select * from cdc_job_state where job_id='{$job_id}' order by id desc limit 1";

        $res = $this->Cluster_model->getList($sql);
        if ($res) {

            foreach ($res as $k => &$v) {
                $v['param'] = json_decode($v['param'], true);
            }

            $data['code'] = 200;
            $data['message'] = '获取成功';
            $data['data'] = $res;

            $data['meta_info'] = $this->getKunlunDbInfo($host);


        } else {
            $data['code'] = 201;
            $data['message'] = '获取失败';
        }
        print_r(json_encode($data));

    }


    public function getStreamRecover()
    {

        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }

        // 获取请求中的 JSON 数据
        $inputData = json_decode(@file_get_contents('php://input'), true);

        $stream_id = $inputData['stream_id'];

        $sql = "select * from cluster_steams_recover where stream_id={$stream_id}";

        $this->load->model('Cluster_model');
        $res = $this->Cluster_model->getList($sql);

        foreach ($res as $k => &$v) {
            $v['prv_params'] = json_decode($v['prv_params'], true);
            $v['now_params'] = json_decode($v['now_params'], true);
            $v['create_at'] = date('Y-m-d H:i:s', $v['create_at']);
        }
        unset($v);
        if ($res) {
            $data['code'] = 200;
            $data['message'] = '获取成功';
            $data['data'] = $res;
        } else {
            $data['code'] = 201;
            $data['message'] = '获取失败';
        }
        print_r(json_encode($data));
    }

}
