<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MY_Controller extends CI_Controller
{
    protected $error_messages = [
        'token_empty' => 'Token不能为空',
        'token_invalid' => 'Token验证失败',
        'user_not_found' => '用户不存在',
        'missing_params' => '缺少必需参数',
        'update_failed' => '更新失败',
        'invalid_request' => '无效的请求数据'
    ];

    protected $Cluster_model;
    protected $Login_model;
    protected $api_response;

    public function __construct()
    {
        parent::__construct();
        $this->setupCORS();
        $this->loadDependencies();
        $this->api_response = new ApiResponse();
    }

    /**
     * 设置CORS头
     */
    protected function setupCORS()
    {
        header('Access-Control-Allow-Origin:*');
        header('Access-Control-Allow-Headers: Content-Type,Content-Length,Accept-Encoding,X-Requested-with, Origin');
        header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE');
        header('Access-Control-Allow-Headers:x-requested-with,content-type,Token');
        header('Content-Type: application/json;charset=utf-8');
    }

    /**
     * 加载依赖
     */
    protected function loadDependencies()
    {
        $this->load->database();
        $this->load->config('myconfig');
        $this->load->model('Cluster_model', 'Cluster_model');
        $this->load->model('Login_model', 'Login_model');
        $this->load->library('ApiResponse');
    }

    /**
     * 统一的JSON响应方法
     */
    protected function jsonResponse($data = [], $code = 200, $message = 'Success')
    {
        $response = $this->api_response->success($data, $message, $code);
        echo json_encode($response);
        return;
    }

    /**
     * 错误响应方法
     */
    protected function errorResponse($message, $code = 500, $data = [])
    {
        $response = $this->api_response->error($message, $code, $data);
        echo json_encode($response);
        return;
    }

    /**
     * 分页响应方法
     */
    protected function paginateResponse($list, $total, $pageNo, $pageSize)
    {
        $response = $this->api_response->paginate($list, $total, $pageNo, $pageSize);
        echo json_encode($response);
        return;
    }

    /**
     * 验证错误响应方法
     */
    protected function validationErrorResponse($errors)
    {
        $response = $this->api_response->validationError($errors);
        echo json_encode($response);
        return;
    }

    /**
     * Token验证方法
     */
    protected function validateToken($token)
    {
        if (empty($token)) {
            throw new Exception($this->error_messages['token_empty']);
        }

        $res_token = $this->Login_model->getToken($token, 'D', config_item('key'));
        if (empty($res_token)) {
            throw new Exception($this->error_messages['token_invalid']);
        }

        $sql = "SELECT count(id) as count FROM kunlun_user WHERE name = ?";
        $res = $this->Login_model->getList($sql, [$res_token]);
        if (empty($res) || $res[0]['count'] == 0) {
            throw new Exception($this->error_messages['user_not_found']);
        }

        return $res_token;
    }

    /**
     * 获取并验证请求头中的Token
     */
    protected function getRequestToken()
    {
        $headers = apache_request_headers();
        return isset($headers['Token']) ? $headers['Token'] : '';
    }

    /**
     * 获取POST请求数据
     */
    protected function getPostData()
    {
        $raw_input = file_get_contents('php://input');
        $data = json_decode($raw_input, true);
        if (empty($data)) {
            throw new Exception($this->error_messages['invalid_request']);
        }
        return $data;
    }

    /**
     * 验证请求数据
     */
    protected function validateRequest($validatorClass, $method, $data)
    {
        $this->load->library('validators/' . $validatorClass);
        $validator = new $validatorClass($data);
        
        if (!$validator->$method()) {
            $this->validationErrorResponse($validator->getErrors());
            return false;
        }
        
        return true;
    }
} 