<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ApiResponse {
    // 成功响应
    public static function success($data = [], $message = 'Success', $code = 200) {
        return [
            'code' => $code,
            'message' => $message,
            'data' => $data
        ];
    }

    // 错误响应
    public static function error($message = 'Error', $code = 500, $data = []) {
        return [
            'code' => $code,
            'message' => $message,
            'data' => $data
        ];
    }

    // 分页数据响应
    public static function paginate($list, $total, $pageNo, $pageSize) {
        return [
            'code' => 200,
            'message' => 'Success',
            'data' => [
                'list' => $list,
                'total' => $total,
                'pageNo' => $pageNo,
                'pageSize' => $pageSize,
                'totalPages' => ceil($total / $pageSize)
            ]
        ];
    }

    // 验证错误响应
    public static function validationError($errors) {
        return [
            'code' => 422,
            'message' => 'Validation Error',
            'data' => $errors
        ];
    }
} 