<?php

namespace PHPMailer\PHPMailer;

class PHPMailer
{
    const CHARSET_ASCII = 'us-ascii';
    const CHARSET_ISO88591 = 'iso-8859-1';
    const CHARSET_UTF8 = 'utf-8';

    const CONTENT_TYPE_PLAINTEXT = 'text/plain';
    const CONTENT_TYPE_TEXT_CALENDAR = 'text/calendar';
    const CONTENT_TYPE_HTML = 'text/html';
    const CONTENT_TYPE_MULTIPART_MIXED = 'multipart/mixed';
    const CONTENT_TYPE_MULTIPART_ALTERNATIVE = 'multipart/alternative';
    const CONTENT_TYPE_MULTIPART_RELATED = 'multipart/related';

    const ENCODING_7BIT = '7bit';
    const ENCODING_8BIT = '8bit';
    const ENCODING_BASE64 = 'base64';
    const ENCODING_BINARY = 'binary';
    const ENCODING_QUOTED_PRINTABLE = 'quoted-printable';

    const ENCRYPTION_STARTTLS = 'tls';
    const ENCRYPTION_SMTPS = 'ssl';

    protected $Priority;
    protected $CharSet = self::CHARSET_UTF8;
    protected $ContentType = self::CONTENT_TYPE_PLAINTEXT;
    protected $Encoding = self::ENCODING_8BIT;
    protected $ErrorInfo = '';
    protected $From = '';
    protected $FromName = '';
    protected $Sender = '';
    protected $Subject = '';
    protected $Body = '';
    protected $AltBody = '';
    protected $Mailer = 'smtp';
    protected $WordWrap = 0;
    protected $Hostname = '';
    protected $MessageID = '';
    protected $MessageDate = '';
    protected $Host = 'localhost';
    protected $Port = 25;
    protected $Helo = '';
    protected $SMTPSecure = '';
    protected $SMTPAutoTLS = true;
    protected $SMTPAuth = false;
    protected $SMTPOptions = [];
    protected $Username = '';
    protected $Password = '';
    protected $AuthType = '';
    protected $Timeout = 300;
    protected $SMTPDebug = 0;
    protected $Debugoutput = 'echo';
    protected $SMTPKeepAlive = false;
    protected $SingleTo = false;
    protected $SingleToArray = [];
    protected $do_verp = false;
    protected $AllowEmpty = false;
    protected $DKIM_selector = '';
    protected $DKIM_identity = '';
    protected $DKIM_passphrase = '';
    protected $DKIM_domain = '';
    protected $DKIM_copyHeaderFields = true;
    protected $DKIM_extraHeaders = [];
    protected $DKIM_private = '';
    protected $DKIM_private_string = '';
    protected $action_function = '';
    protected $XMailer = '';

    public function isSMTP()
    {
        $this->Mailer = 'smtp';
    }

    public function setFrom($address, $name = '', $auto = true)
    {
        $this->From = $address;
        $this->FromName = $name;
        return true;
    }

    public function addAddress($address, $name = '')
    {
        return true;
    }

    public function setSubject($subject)
    {
        $this->Subject = $subject;
        return true;
    }

    public function setBody($body)
    {
        $this->Body = $body;
        return true;
    }

    public function send()
    {
        try {
            if (!$this->preSend()) {
                return false;
            }
            return $this->postSend();
        } catch (Exception $exc) {
            $this->mailHeader = '';
            $this->setError($exc->getMessage());
            if ($this->exceptions) {
                throw $exc;
            }
            return false;
        }
    }

    protected function preSend()
    {
        try {
            $this->mailHeader = '';
            if ((count($this->to) + count($this->cc) + count($this->bcc)) < 1) {
                throw new Exception('Must provide at least one recipient email address.');
            }
        } catch (Exception $exc) {
            $this->setError($exc->getMessage());
            if ($this->exceptions) {
                throw $exc;
            }
            return false;
        }
        return true;
    }

    protected function postSend()
    {
        return true;
    }

    protected function setError($msg)
    {
        $this->ErrorInfo = $msg;
    }

    public function getError()
    {
        return $this->ErrorInfo;
    }
} 