package config

import (
	"github.com/spf13/viper"
	"log"
)

var KafkaConfig struct {
	BootstrapServers string
	TopicPrefix      string
}

var ElasticsearchConfig struct {
	Host string
}

var DatabaseType string
var TablePrefix string

func LoadConfig() {
	viper.SetConfigName("config")
	viper.SetConfigType("ini")
	viper.AddConfigPath(".")

	if err := viper.ReadInConfig(); err != nil {
		log.Fatalf("无法读取配置文件: %v", err)
	}

	KafkaConfig.BootstrapServers = viper.GetString("kafka.bootstrap_servers")
	KafkaConfig.TopicPrefix = viper.GetString("kafka.topic_prefix")

	ElasticsearchConfig.Host = viper.GetString("Elasticsearch.host")

	DatabaseType = viper.GetString("database.type")
	TablePrefix = viper.GetString("database.table_prefix")
}
