package database

type DBCluster struct {
	ID               uint   `gorm:"primaryKey;autoIncrement" json:"id"`
	Name             string `gorm:"size:120;not null;unique" json:"name"`
	NickName         string `gorm:"size:120" json:"nick_name,omitempty"`
	Owner            string `gorm:"size:120;not null" json:"owner"`
	DDLLogTblName    string `gorm:"size:120;not null" json:"ddl_log_tblname"`
	Business         string `gorm:"size:120;not null" json:"business"`
	Memo             string `gorm:"type:text" json:"memo,omitempty"`
	Status           string `gorm:"type:enum('inuse','deleted','creating');default:'creating'" json:"status"`
	HAMode           string `gorm:"type:enum('no_rep','mgr','rbr');not null" json:"ha_mode"`
	EncryptBackup    bool   `gorm:"type:tinyint(1);default:0" json:"encrypt_backup"`
	BackupEncryptKey string `gorm:"size:256" json:"backup_encrypt_key,omitempty"`
	WhenDeleted      string `gorm:"size:24" json:"when_deleted,omitempty"`
	WhenCreated      string `gorm:"size:24" json:"when_created,omitempty"`
}

type DBClusterSearch struct {
	ID     int
	Name   string
	Status string
}

func (DBCluster) TableName() string {
	return "db_clusters"
}
