<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AuthController extends CI_Controller
{
    public $Login_model;
    private $config_items = array();
    private $key;

    public function __construct()
    {
        parent::__construct();
        
        // 设置响应头
        header('Access-Control-Allow-Origin:*');
        header('Access-Control-Allow-Headers: Content-Type,Content-Length,Accept-Encoding,X-Requested-with, Origin');
        header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE');
        header('Access-Control-Allow-Headers:x-requested-with,content-type,Token');
        header('Content-Type: application/json;charset=utf-8');

        // 加载配置
        $CI = &get_instance();
        $CI->load->config('myconfig', TRUE);
        $this->config_items = $CI->config->item('myconfig');
        
        // 加载模型
        $this->load->model('Login_model');

        // 初始化配置项
        if(is_array($this->config_items)) {
            $this->key = isset($this->config_items['key']) ? $this->config_items['key'] : '';
        }
    }

    public function login()
    {
        $string = json_decode(@file_get_contents('php://input'), true);
        $user_name = $string['username'];
        $password = $string['password'];
        
        if (empty($user_name) || empty($password)) {
            $data['code'] = 401;
            $data['message'] = '账户或密码不能为空';
            print_r(json_encode($data));
            return;
        }


        $this->load->model('Db_model');
        $this->Db_model->CreateTable();
        $this->Db_model->AlterTable();

        
        //验证用户名和密码
        if ($user_name == 'super_dba' && $password == 'super_dba') {
            $sql_super = "select count(id) as count,id from kunlun_user where name='$user_name' and password='$password';";
            $res_super = $this->Login_model->getList($sql_super);
            if ($res_super[0]['count'] == 1) {
                $token = $this->Login_model->getToken($user_name, 'E', $this->key);
                $data['Token'] = $token;
                $data['num'] = 2;
                $data['code'] = 200;
                $data['userName'] = $user_name;
                $data['message'] = '修改密码';
                print_r(json_encode($data));
                return;
            }
        }

        $saas = $this->loadMeta();
        
        if (isset($saas['saas']) && ($saas['saas'] > 0)) {
            $sql = "select id,supper_admin,main_user,pid from kunlun_user where name='$user_name' and password='$password';";
        } else {
            $sql = "select * from kunlun_user where name='$user_name' and password='$password';";
        }

        $res = $this->Login_model->getList($sql);
        
        if ($res === false) {
            $data['code'] = 501;
            $data['message'] = '账户或密码错误';
            print_r(json_encode($data));
            return;
        }

        $user_count = count($res);
        if ($user_count > 1) {
            $token = $this->Login_model->getToken($user_name, 'E', $this->key);
            $data['Token'] = $token;
            $data['num'] = $user_count;
            $data['code'] = 301;
            $data['message'] = '用户重复';
            print_r(json_encode($data));
            return;
        }

        if ($user_count == 1) {
            $this->handleSuccessfulLogin($res[0], $user_name);
        } else {
            $data['code'] = 501;
            $data['message'] = '账户或密码错误';
            print_r(json_encode($data));
        }
    }

    public function changePassword()
    {
        header('content-type: application/json; charset=utf-8');
        //获取token
        $arr = apache_request_headers();
        $token = $arr["Token"];
        
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }

        $string = json_decode(@file_get_contents('php://input'), true);
        $user_name = $string['username'];
        $password = $string['password'];
        
        if (empty($user_name) || empty($password)) {
            $data['code'] = 201;
            $data['message'] = '账户或密码不能为空';
            print_r(json_encode($data));
            return;
        }

        //验证token
        $res_token = $this->Login_model->getToken($token, 'D', $this->key);
        if (empty($res_token)) {
            $data['code'] = 500;
            $data['message'] = 'token错误';
            print_r(json_encode($data));
            return;
        }

        $sql = "select count(id) as count from kunlun_user where name='$res_token';";
        $res = $this->Login_model->getList($sql);
        
        if (empty($res) || $res[0]['count'] == 0) {
            $data['code'] = 500;
            $data['message'] = 'token错误';
            print_r(json_encode($data));
            return;
        }

        $sql_user = "select count(id) as count from kunlun_user where name='$user_name' and password='$password'";
        $res_user = $this->Login_model->getList($sql_user);
        
        if (empty($res_user)) {
            $data['code'] = 500;
            $data['message'] = '账户或密码错误';
            print_r(json_encode($data));
            return;
        }

        if ($res_user[0]['count'] == 0) {
            $sql_update = "update kunlun_user set password='$password' where name='$user_name';";
            $res_update = $this->Login_model->updateList($sql_update);
            if ($res_update == 1) {
                $data['code'] = 200;
                $data['message'] = '修改密码成功';
            } else {
                $data['code'] = 501;
                $data['message'] = '修改密码失败';
            }
        } elseif ($res_user[0]['count'] == 1) {
            $data['code'] = 500;
            $data['message'] = '新旧密码不能一致';
        } else {
            $data['code'] = 501;
            $data['message'] = '存在多条相同的账户数据';
        }
        
        print_r(json_encode($data));
    }

    private function loadMeta()
    {
        $string = file_get_contents('./json/meta.json');
        $data = json_decode($string, true);
        return $data;
    }

    private function handleSuccessfulLogin($user, $user_name)
    {
        $userId = $user['id'];
        $token = $this->Login_model->getToken($user_name, 'E', $this->key);
        
        // 如果是 super_dba 用户，直接赋予所有权限
        if ($user_name === 'super_dba') {
            $data = [
                'priv' => [
                    'user_add_priv' => 'Y',
                    'user_drop_priv' => 'Y',
                    'user_grant_priv' => 'Y',
                    'user_edit_priv' => 'Y',
                    'role_add_priv' => 'Y',
                    'role_drop_priv' => 'Y',
                    'role_edit_priv' => 'Y',
                    'machine_priv' => 'Y',
                    'cluster_creata_priv' => 'Y',
                    'cluster_drop_priv' => 'Y',
                    'shard_create_priv' => 'Y',
                    'shard_drop_priv' => 'Y',
                    'storage_node_create_priv' => 'Y',
                    'storage_node_drop_priv' => 'Y',
                    'compute_node_create_priv' => 'Y',
                    'compute_node_drop_priv' => 'Y',
                    'machine_add_priv' => 'Y',
                    'machine_drop_priv' => 'Y',
                    'backup_service_enable_priv' => 'Y',
                    'backup_service_disable_priv' => 'Y',
                    'storage_enable_priv' => 'Y',
                    'storage_disable_priv' => 'Y',
                    'compute_enable_priv' => 'Y',
                    'compute_disable_priv' => 'Y',
                    'backup_priv' => 'Y',
                    'restore_priv' => 'Y',
                    'expand_cluster_priv' => 'Y',
                    'shrink_cluster_priv' => 'Y'
                ],
                'Token' => $token,
                'code' => 200,
                'num' => 1,
                'userName' => $user_name,
                'supper_admin' => '1',
                'main_user' => '1',
                'apply_all_cluster' => '1',
                'affected_clusters' => null,
                'message' => 'success'
            ];
            print_r(json_encode($data));
            return;
        }

        // 对于其他用户，继续使用原有的权限处理逻辑
        $sql_role = $this->buildRoleQuery($userId);
        $res_role = $this->Login_model->getList($sql_role);
        
        if (empty($res_role)) {
            $data['code'] = 402;
            $data['message'] = '该用户未授权，没有登录权限';
            print_r(json_encode($data));
            return;
        }

        $apply_all_cluster = '';
        $affected_clusters = '';
        
        // 处理集群应用权限
        foreach ($res_role as $role) {
            if (!empty($role['apply_all_cluster']) && $role['apply_all_cluster'] == 1) {
                $apply_all_cluster = $role['apply_all_cluster'];
                $affected_clusters = $role['affected_clusters'];
                break;
            } elseif (!empty($role['apply_all_cluster']) && $role['apply_all_cluster'] == 2) {
                $apply_all_cluster = $role['apply_all_cluster'];
                $affected_clusters .= $role['affected_clusters'] . ',';
            }
        }

        // 获取用户权限
        $priv = $this->processRolePrivileges($res_role);
        
        if ($affected_clusters != null) {
            $affected_clusters = rtrim($affected_clusters, ',');
        }

        $affected_clusters = $this->unique($affected_clusters);
        
        $data = [
            'Token' => $token,
            'code' => 200,
            'num' => 1,
            'userName' => $user_name,
            'supper_admin' => isset($user['supper_admin']) ? $user['supper_admin'] : 1,
            'main_user' => isset($user['main_user']) ? $user['main_user'] : 1,
            'apply_all_cluster' => $apply_all_cluster,
            'affected_clusters' => $affected_clusters,
            'message' => 'success',
            'priv' => $priv
        ];


        print_r(json_encode($data));
    }

    private function buildRoleQuery($userId)
    {
        return "select role_id,apply_all_cluster,affected_clusters from kunlun_role_assign where user_id='$userId' and valid_period='permanent' 
                union select role_id,apply_all_cluster,affected_clusters from kunlun_role_assign where user_id='$userId' and valid_period='from_to' and start_ts is not null and start_ts<now() and end_ts is null
                union select role_id,apply_all_cluster,affected_clusters from kunlun_role_assign where user_id='$userId' and valid_period='from_to' and end_ts is not null and end_ts>now() and start_ts is null
                union select role_id,apply_all_cluster,affected_clusters from kunlun_role_assign where user_id='$userId' and valid_period='from_to' and end_ts is not null  and start_ts is not null and start_ts<now() and end_ts>now();";
    }

    private function processRolePrivileges($res_role)
    {
        $role_count = count($res_role);
        if ($role_count == 1) {
            return $res_role[0];
        }

        // 初始化权限
        $arr = array(
            'user_add_priv' => 'N',
            'user_drop_priv' => 'N',
            'user_edit_priv' => 'N',
            'user_grant_priv' => 'N',
            'role_add_priv' => 'N',
            'role_drop_priv' => 'N',
            'role_edit_priv' => 'N',
            'cluster_creata_priv' => 'N',
            'cluster_drop_priv' => 'N',
            'backup_priv' => 'N',
            'restore_priv' => 'N',
            'expand_cluster_priv' => 'N',
            'shrink_cluster_priv' => 'N',
            'storage_node_create_priv' => 'N',
            'storage_node_drop_priv' => 'N',
            'storage_enable_priv' => 'N',
            'storage_disable_priv' => 'N',
            'shard_create_priv' => 'N',
            'shard_drop_priv' => 'N',
            'compute_node_create_priv' => 'N',
            'compute_node_drop_priv' => 'N',
            'compute_enable_priv' => 'N',
            'compute_disable_priv' => 'N',
            'machine_add_priv' => 'N',
            'machine_priv' => 'N',
            'machine_drop_priv' => 'N',
            'backup_service_enable_priv' => 'N',
            'backup_service_disable_priv' => 'N'
        );

        // 获取角色ID
        $role_ids = array();
        foreach ($res_role as $role) {
            if (!empty($role['role_id'])) {
                $role_ids[] = $role['role_id'];
            }
        }
        $role_id = implode(',', $role_ids);

        // 获取权限
        $sql_priv = "select user_add_priv,user_drop_priv,user_grant_priv,user_edit_priv,role_add_priv,role_drop_priv,role_edit_priv,machine_priv,cluster_creata_priv,cluster_drop_priv,shard_create_priv,shard_drop_priv,storage_node_create_priv,storage_node_drop_priv,compute_node_create_priv,compute_node_drop_priv,machine_add_priv,machine_drop_priv,backup_service_enable_priv,backup_service_disable_priv,storage_enable_priv,storage_disable_priv,compute_enable_priv,compute_disable_priv,backup_priv,restore_priv,expand_cluster_priv,shrink_cluster_priv from kunlun_role_privilege where id in($role_id);";
        $res_priv = $this->Login_model->getList($sql_priv);

        if (!empty($res_priv)) {
            foreach ($res_priv as $priv) {
                foreach ($priv as $key => $value) {
                    if ($value == 'Y') {
                        $arr[$key] = $value;
                    }
                }
            }
        }

        return $arr;
    }

    private function unique($str)
    {
        if ($str == null) {
            return $str;
        }
        $arr = explode(',', $str);
        $arr = array_unique($arr);
        $data = implode(',', $arr);
        $data = trim($data, ',');
        return $data;
    }
} 