<?php
defined('BASEPATH') or exit('No direct script access allowed');

class SystemController extends CI_Controller
{
    public $Login_model;
    public $Change_model;
    public $Cluster_model;
    private $config_items = array();
    private $grafana_key;
    private $grafana_svr;
    private $post_url;
    private $saas_server;

    public function __construct()
    {
        parent::__construct();
        
        // 设置响应头
        header('Access-Control-Allow-Origin:*');
        header('Access-Control-Allow-Headers: Content-Type,Content-Length,Accept-Encoding,X-Requested-with, Origin');
        header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE');
        header('Access-Control-Allow-Headers:x-requested-with,content-type,Token');
        header('Content-Type: application/json;charset=utf-8');

        // 加载配置
        $CI = &get_instance();
        $CI->load->config('myconfig', TRUE);
        $this->config_items = $CI->config->item('myconfig');
        
        // 加载模型
        $this->load->model('Login_model');
        $this->load->model('Change_model');
        $this->load->model('Cluster_model');

        // 初始化配置项
        if(is_array($this->config_items)) {
            $this->grafana_key = isset($this->config_items['grafana_key']) ? $this->config_items['grafana_key'] : '';
            $this->grafana_svr = isset($this->config_items['grafana_svr']) ? $this->config_items['grafana_svr'] : '';
            $this->post_url = isset($this->config_items['post_url']) ? $this->config_items['post_url'] : '';
            $this->saas_server = isset($this->config_items['saas_server']) ? $this->config_items['saas_server'] : '';
        }
    }

    public function getModel()
    {
        $meta = $this->loadMeta();
        $ip = "";
        $port = "";
        $saas = 0;
        $needUpdate = true;

        // 从meta.json获取第一个节点的IP和端口信息
        if (count($meta) > 0 && isset($meta['nodes']) && !empty($meta['nodes'])) {
            $ip = $meta['nodes'][0]['ip'];
            $port = $meta['nodes'][0]['port'];
            $saas = isset($meta['saas']) ? $meta['saas'] : 0;
        } else {
            $needUpdate = false;
        }

        $host = $this->saas_server;
        $port_saas = 8888;
        
        // 尝试连接saas_server端口
        $connection = @fsockopen($host, $port_saas);
        
        // 无论是否连接成功，都要检查并更新配置
        if ($connection) {
            fclose($connection);
        }
        
        // 只有在有有效的IP和端口时才尝试更新配置
        if ($needUpdate && !empty($ip) && !empty($port)) {
            // 先获取 Cluster Manager 信息
            $sql_mgr = "select * from cluster_mgr_nodes where id=1";
            $res_mgr = $this->Cluster_model->getMysqlRes($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_mgr);

            if ($res_mgr['code'] == 200 && isset($res_mgr['list']) && !empty($res_mgr['list'])) {
                $mgr_ip = $res_mgr['list'][0]['hostaddr'];
                $mgr_port = $res_mgr['list'][0]['port'];
                $post_url = 'http://' . $mgr_ip . ':' . $mgr_port . '/HttpService/Emit';

                // 检查数据库高可用模式
                $sql_dbha = "select value from kunlun_metadata_db.global_configuration";
                $res_dbha = $this->Cluster_model->getMysqlRes($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_dbha);

                if ($res_dbha['code'] == 200 && isset($res_dbha['list']) && !empty($res_dbha['list'])) {
                    $dbha_mode = $res_dbha['list'][0]['value'];

                    if ($dbha_mode == 'rbr') {
                        // RBR 模式：使用 get_meta_master API 获取主节点
                        $user_name = $this->user_name ?: 'super_dba';
                        $version = $this->version ?: '1.0';
                        $microtime = microtime(true);
                        $timestamp = substr($microtime, 0, 13);

                        $post_string = array(
                            'user_name' => $user_name,         // 用户名：super_dba
                            'version' => $version,             // 版本号：1.0
                            'job_id' => '',                    // 作业ID，此处为空
                            'timestamp' => $timestamp,         // 请求时间戳
                            'job_type' => 'get_meta_master'   // 作业类型：获取元数据主节点
                        );

                        $post_arr = $this->getMetaMaster($post_string, $post_url);

                        if ($post_arr && $post_arr['error_code'] == 0) {
                            if (!empty($post_arr['attachment']['master_host'])) {
                                // 解析主节点地址（格式：IP:PORT）
                                $meta_ips = explode(':', $post_arr['attachment']['master_host']);
                                $master_ip = $meta_ips[0];
                                $master_port = $meta_ips[1];

                                $this->updateConfigFiles($master_ip, $master_port, $saas, $mgr_ip, $mgr_port);
                            } else {
                                // API 返回成功但没有主节点信息，使用默认方式
                                $this->getMetaMainByQuery($ip, $port, $saas, $mgr_ip, $mgr_port);
                            }
                        } else {
                            // API 调用失败，使用默认方式
                            $this->getMetaMainByQuery($ip, $port, $saas, $mgr_ip, $mgr_port);
                        }
                    } else {
                        // 非 RBR 模式，使用传统查询方式
                        $this->getMetaMainByQuery($ip, $port, $saas, $mgr_ip, $mgr_port);
                    }
                } else {
                    // 无法获取数据库模式，使用传统查询方式
                    $this->getMetaMainByQuery($ip, $port, $saas, $mgr_ip, $mgr_port);
                }
            } else {
                // 无法获取 Cluster Manager 信息，使用 meta.json 中的第一个节点
                $this->updateConfigFiles($ip, $port, $saas);
            }
        }

        $data = $this->loadMeta();
        $sql = "select * from kunlun_user where name='super_dba'";
        $res = $this->Login_model->getList($sql);

        if (!empty($res)) {
            $user = $res[0];
            if ($user['supper_admin'] == '') {
                $sql_update = "update kunlun_user set supper_admin=1,update_time=now(),main_user=1 where name='super_dba'";
                $this->Login_model->updateList($sql_update);
            }
        }

        if (isset($data['saas'])) {
            $json['model'] = $data['saas'];
            $json['code'] = 200;
            print_r(json_encode($json));
        } else {
            $json['model'] = 0;
            $json['code'] = 200;
            print_r(json_encode($json));
        }
    }

    /**
     * 调用 get_meta_master API 获取元数据主节点信息
     *
     * @param array $post_string 请求参数数组
     * @param string $post_url Cluster Manager 的 HTTP 服务端点
     * @return array API 响应数组
     */
    public function getMetaMaster($post_string, $post_url)
    {
        $this->load->model('Change_model');

        // 将参数数组转换为JSON字符串
        $post_data = str_replace("\\/", "/", json_encode($post_string));

        // 通过Change_model的postData方法发送HTTP请求到Cluster Manager
        $post_arr = $this->Change_model->postData($post_data, $post_url);

        // 解析返回的JSON响应
        $post_arr = json_decode($post_arr, TRUE);

        return $post_arr;
    }

    /**
     * 使用传统查询方式获取元数据主节点
     *
     * @param string $ip 元数据节点IP
     * @param string $port 元数据节点端口
     * @param int $saas SAAS模式标识
     * @param string $mgr_ip Cluster Manager IP
     * @param string $mgr_port Cluster Manager 端口
     */
    private function getMetaMainByQuery($ip, $port, $saas, $mgr_ip = "127.0.0.1", $mgr_port = 8888)
    {
        // 获取元数据的主节点
        $sql_main = "select hostaddr,port from meta_db_nodes where member_state='source'";
        $res_main = $this->Cluster_model->getMysqlRes($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_main);

        if ($res_main['code'] == 200 && isset($res_main['list']) && !empty($res_main['list'])) {
            $this->updateConfigFiles($res_main['list'][0]['hostaddr'], $res_main['list'][0]['port'], $saas, $mgr_ip, $mgr_port);
        } else {
            // 如果无法获取主节点信息，使用meta.json中的第一个节点
            $this->updateConfigFiles($ip, $port, $saas, $mgr_ip, $mgr_port);
        }
    }

    private function loadMeta()
    {
        $string = file_get_contents('./json/meta.json');
        $data = json_decode($string, true);
        return $data;
    }

    private function updateConfigFiles($ip, $port, $saas,$mgr_ip="127.0.0.1",$mgr_port=8888)
    {
        // 更新config.yaml配置文件
        $configpath = "./application/config/config_tpl.yaml";
        $config = file_get_contents($configpath);
        $config = str_replace('{{server_ip_str}}', $ip, $config);
        $config = str_replace('{{server_port_str}}', $port, $config);
        $config = str_replace('{{server_saas_str}}', $saas, $config);
        file_put_contents("./config.yaml", $config);
        
        // 更新yaml中所有的path值
        $yaml_content = file_get_contents("./config.yaml");
        $yaml_content = preg_replace('/path: \d+\.\d+\.\d+\.\d+/i', 'path: ' . $ip, $yaml_content);
        file_put_contents("./config.yaml", $yaml_content);
        
        // 获取 Grafana API key
        $grafana_key = $this->getGrafanaApiKey();
    
        // 更新myconfig.php配置文件
        $myconfigpath = "./application/config/myconfig_tpl.php";
        $myconfig = file_get_contents($myconfigpath);
        
        // 替换所有模板变量
        $saas_server = $ip . ':' . $port;
        $post_url = 'http://' . $mgr_ip . ':' . $mgr_port . '/HttpService/Emit';
        
        // 替换特定的配置项
        $myconfig = str_replace('{{post_url}}', $post_url, $myconfig);
        $myconfig = str_replace('\'127.0.0.1:8888\'', '\'' . $saas_server . '\'', $myconfig);
        // 替换grafana_key
        $myconfig = str_replace('{{grafana_key}}', $grafana_key, $myconfig);
        
        file_put_contents("./application/config/myconfig.php", $myconfig);
        
        sleep(1);

        $command = $_SERVER['DOCUMENT_ROOT'] . '/KunlunMonitor/saas_server_x86_64 > /dev/null 2>&1 &';
        exec($command, $output, $returnCode);

        try {
            $this->updateDatabaseConfig($ip, $port);
        } catch (Exception $e) {
            log_message('error', 'Failed to update database config: ' . $e->getMessage());
        }
    }

    private function updateDatabaseConfig($host, $port)
    {
        $config = "<?php
defined('BASEPATH') OR exit('No direct script access allowed');
\$active_group = 'default';
\$query_builder = TRUE;
\$db_debug=FALSE;
\$db['role']=array(
    'dsn'	=> '',
    'hostname' => '$host',
    'port' => $port,
    'username' => 'pgx',
    'password' => 'pgx_pwd',
    'database' => 'kunlun_dba_tools_db',
    'dbdriver' => 'mysqli',
    'dbprefix' => '',
    'pconnect' => FALSE,
    'db_debug' => FALSE,
    'cache_on' => FALSE,
    'cachedir' => '',
    'char_set' => 'utf8',
    'dbcollat' => 'utf8_general_ci',
    'swap_pre' => '',
    'encrypt' => FALSE,
    'compress' => FALSE,
    'stricton' => FALSE,
    'failover' => array(),
    'options' => array(PDO::ATTR_TIMEOUT => 5),
    'save_queries' => TRUE,
);
\$db['default']=array(
    'dsn'	=> '',
    'hostname' => '$host',
    'port' => $port,
    'username' => 'pgx',
    'password' => 'pgx_pwd',
    'database' => 'kunlun_metadata_db',
    'dbdriver' => 'mysqli',
    'dbprefix' => '',
    'pconnect' => FALSE,
    'db_debug' => FALSE,
    'cache_on' => FALSE,
    'cachedir' => '',
    'char_set' => 'utf8',
    'dbcollat' => 'utf8_general_ci',
    'swap_pre' => '',
    'encrypt' => FALSE,
    'compress' => FALSE,
    'stricton' => FALSE,
    'failover' => array(),
    'options' => array(PDO::ATTR_TIMEOUT => 5),
    'save_queries' => TRUE,
);";

        file_put_contents("./application/config/database.php", $config);
        $this->init_metadata_node();
    }

    public function init_metadata_node()
    {
        //查user_id
        $user_sql = "select id from kunlun_user where name=?";
        $res_user = $this->Login_model->getList($user_sql, array('super_dba'));

        if (!empty($res_user)) {
            $user_id = $res_user[0]['id'];
        } else {
            $data['code'] = 500;
            $data['message'] = '该用户不存在';
            print_r(json_encode($data));
            return;
        }

        //查当前元数据ips
        $sql_meta = "select id,hostaddr,port from meta_db_nodes ";
        $res_meta = $this->Cluster_model->getList($sql_meta);

        $ips = '';
        foreach ($res_meta as $row => $value) {
            $ip = '';
            $port = '';
            foreach ($value as $key1 => $value1) {
                if ($key1 == 'hostaddr') {
                    $ip = $value1;
                }
                if ($key1 == 'port') {
                    $port = $value1;
                }
            }
            $ips .= $ip . ':' . $port . ',';
        }
        $rcr_meta = substr($ips, 0, strlen($ips) - 1);

        //先查是否存在此条数据，存在更新 不存在insert
        $select_sql = "select * from cluster_meta_info where name=? and rcr_meta=?";
        $params = array('system', $rcr_meta);
        $res_select = $this->Login_model->getList($select_sql, $params);

        if (!$res_select) {
            $insert_sql = "insert into cluster_meta_info(user_id,name,rcr_meta) values ('$user_id','system','$rcr_meta'); ";
            $this->Login_model->updateList($insert_sql);
        }
    }

    private function my_exec($cmd, $input = '')
    {
        $proc = proc_open($cmd, array(
            0 => array('pipe', 'r'),
            1 => array('pipe', 'w'),
            2 => array('pipe', 'w')
        ), $pipes);
        
        fwrite($pipes[0], $input);
        fclose($pipes[0]);
        
        $stdout = stream_get_contents($pipes[1]);
        fclose($pipes[1]);
        
        $stderr = stream_get_contents($pipes[2]);
        fclose($pipes[2]);
        
        $rtn = proc_close($proc);
        return $rtn;
    }

    /**
     * 获取Grafana API Key
     * 
     * @return string Grafana API Key
     */
    private function getGrafanaApiKey()
    {
        // 使用类成员变量grafana_svr
        $grafana_host = $this->grafana_svr ?: '127.0.0.1:3000';
        $username = 'admin';
        $password = 'admin';
        
        try {
            // 从grafana_host中提取主机名和端口
            $parts = explode(':', $grafana_host);
            $host = $parts[0];
            $port = isset($parts[1]) ? $parts[1] : 3000;
            
            // 1. 验证Grafana服务是否可用
            $connection = @fsockopen($host, $port, $errno, $errstr, 1);
            if (!$connection) {
                log_message('error', 'Cannot connect to Grafana server: ' . $errstr);
                return 'grafana-api-key-error';
            }
            fclose($connection);
            
            // 2. 创建API Key
            $url = "http://{$grafana_host}/api/auth/keys";
            $data = [
                'name' => 'kunlun-monitor-api-key-' . time(),
                'role' => 'Admin',
                'secondsToLive' => 0 // 永不过期
            ];
            
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 1,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'Accept: application/json'
                ],
                CURLOPT_USERPWD => "{$username}:{$password}"
            ]);
            
            $response = curl_exec($curl);
            $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $err = curl_error($curl);
            curl_close($curl);
            
            if ($err) {
                log_message('error', 'cURL Error when getting Grafana API key: ' . $err);
                return 'grafana-api-key-error';
            }
            
            if ($httpCode >= 200 && $httpCode < 300) {
                $result = json_decode($response, true);
                if (isset($result['key'])) {
                    return $result['key'];
                }
            }
            
            // 如果无法创建新的API key，尝试使用现有的API key
            log_message('error', 'Failed to create Grafana API key. HTTP Code: ' . $httpCode . ', Response: ' . $response);
            
            // 3. 如果创建失败，尝试获取已有的API key
            $url = "http://{$grafana_host}/api/auth/keys";
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 1,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_HTTPHEADER => [
                    'Accept: application/json'
                ],
                CURLOPT_USERPWD => "{$username}:{$password}"
            ]);
            
            $response = curl_exec($curl);
            $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);
            
            if ($httpCode >= 200 && $httpCode < 300) {
                $keys = json_decode($response, true);
                if (is_array($keys) && !empty($keys)) {
                    // 找到一个kunlun开头的key
                    foreach ($keys as $key) {
                        if (isset($key['name']) && strpos($key['name'], 'kunlun') !== false) {
                            return $key['key'];
                        }
                    }
                    // 如果没有kunlun开头的key，返回第一个
                    if (isset($keys[0]['key'])) {
                        return $keys[0]['key'];
                    }
                }
            }
            
            log_message('error', 'Failed to get existing Grafana API keys. HTTP Code: ' . $httpCode);
            return 'eyJrIjoiWkdVM01UazVZekF0WkRFMU5TMDBOR05pTFRobFpUUXRNREkwWXpoaU1ERmpPVEZpTENKbiI6ImFkbWluIn0=';
            
        } catch (Exception $e) {
            log_message('error', 'Exception when getting Grafana API key: ' . $e->getMessage());
            // 返回一个默认值，避免配置文件出错
            return 'eyJrIjoiWkdVM01UazVZekF0WkRFMU5TMDBOR05pTFRobFpUUXRNREkwWXpoaU1ERmpPVEZpTENKbiI6ImFkbWluIn0=';
        }
    }
} 