<?php
defined('BASEPATH') or exit('No direct script access allowed');

class RCR extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->config->load('myconfig');
        $this->key = $this->config->item('key');
        $this->post_url = $this->config->item('post_url');
        
    }


    public function getShardInfo($ips_arr)
    {
        $ip_arr = explode(',', $ips_arr);
        foreach ($ip_arr as $knode => $vnode) {

            $meta_arr = explode(':', $vnode);
            $res_meta = $this->getMeta($meta_arr[0], $meta_arr[1]);
            if ($res_meta['code'] == 200) {
                $cluster_sql = "select * from db_clusters where when_deleted is null ";
                $res_main = $this->Change_model->getMysql($meta_arr[0], $meta_arr[1], 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $cluster_sql);
                $shard_sql = "select * from kunlun_metadata_db.shard_nodes where when_deleted is null and  db_cluster_id=" . $res_main[0] . " and member_state='source'";
                $shards_main = $this->Change_model->getMysql($meta_arr[0], $meta_arr[1], 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $shard_sql);
                $get_gtid_sql = "show master status";
                $shards_master = $this->Change_model->getMysql($shards_main[2], $shards_main[3], 'pgx', 'pgx_pwd', '', $get_gtid_sql);
                $shard_parms = [
                    [
                        "shard_id" => $shards_main[6],
                        "dump_hostaddr" => $shards_main[2],
                        "dump_port" => $shards_main[3],
                        "binlog_file" => $shards_master[0],
                        "binlog_pos" => $shards_master[1],
                        "gtid_set" => $shards_master[4],
                    ]
                ];
                return $shard_parms;
            }
        }
    }


    public function getRCRList()
    {
        $pageNo = $this->input->get('pageNo');
        $pageSize = $this->input->get('pageSize');
        $hostaddr = $this->input->get('hostaddr');
        $user_name = $this->input->get('user_name');
        $start = ($pageNo - 1) * $pageSize;
        $this->load->model('Login_model');
        $this->load->model('Cluster_model');

        $user_id = '';
        $res_user = $this->Login_model->getUserId($user_name);
        if ($res_user['code'] == 200) {
            $user_id = $res_user['message'];
        }

        $sql = "select * from cluster_rcr_infos where id is not null and status!='deleted'";
        if (!empty($hostaddr)) {
            $sql .= " and  master_rcr_meta like '%$hostaddr%'";
        }
        $sql .= " order by id desc limit " . $pageSize . " offset " . $start;
        $res = $this->Cluster_model->getList($sql);


        if ($res === false) {
            $res = array();
        } else {
            foreach ($res as $key => $row) {
                foreach ($row as $k => $v) {
                    if ($k == 'master_rcr_meta') {
                        $name = '';
                        if (!empty($v)) {
                            $meta_name = $this->getMetaName($v, $user_id);
                            if (!empty($meta_name)) {
                                $name = $meta_name[0]['name'];
                            }
                        }
                        $res[$key]['master_meta_name'] = $name;
                    }
                    if ($k == 'slave_rcr_meta') {
                        $name = '';
                        if (!empty($v)) {
                            $meta_name = $this->getMetaName($v, $user_id);
                            if (!empty($meta_name)) {
                                $name = $meta_name[0]['name'];
                            }
                        }
                        $res[$key]['slave_meta_name'] = $name;
                    }
                    if ($k == 'id') {
                        $name = '';
                        if (!empty($v)) {
                            $meta_name = $this->getMaxDelayTime($v, $user_id);
                            if (!empty($meta_name)) {
                                $name = $meta_name[0]['max_delay_time'];
                            }
                        }
                        $res[$key]['max_delay_time'] = $name;
                    }
                }
            }
        }

        foreach ($res as $key => $row) {
            $res[$key]['master_shard_info'] = $this->getShardInfo($row['master_rcr_meta']);
            $res[$key]['slave_shard_info'] = $this->getShardInfo($row['slave_rcr_meta']);
        }

        $sql_total = "select count(id) as count from cluster_rcr_infos where  id is not null and status!='deleted'";
        if (!empty($username)) {
            $sql_total .= " and  hostaddr like '%$username%'";
        }
        $res_total = $this->Cluster_model->getList($sql_total);
        $data['code'] = 200;
        $data['list'] = $res;
        $data['total'] = $res_total ? (int)$res_total[0]['count'] : 0;
        print_r(json_encode($data));
    }


    public function createRCR()
    {
        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $slave = $string['slave'];
        $postJson = $string['postData'];
        $slave_meta = '';
        $ips = '';
        $ip = '';
        $port = '';
        $string_info = '';
        $post_url = '';

        $this->load->model('Cluster_model');
        $post_data = str_replace("\\/", "/", json_encode($postJson));
        $post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
        $post_arr = json_decode($post_arr, TRUE);
        $data = $post_arr;
        print_r(json_encode($data));
    }

    public function editMachine()
    {
        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        //调接口
        $this->load->model('Cluster_model');
        $post_data = str_replace("\\/", "/", json_encode($string));
        $post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
        $post_arr = json_decode($post_arr, TRUE);
        $data = $post_arr;
        print_r(json_encode($data));
    }

    public function deleteMachine()
    {
        $arr = apache_request_headers();//获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        //调接口
        $this->load->model('Cluster_model');
        $post_data = str_replace("\\/", "/", json_encode($string));
        $post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
        $post_arr = json_decode($post_arr, TRUE);
        $data = $post_arr;
        print_r(json_encode($data));
    }

    public function getMetaMachine()
    {
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        $user_name = $this->input->get('user_name');
        $this->load->model('Login_model');
        $user_id = '';
        $res_user = $this->Login_model->getUserId($user_name);
        if ($res_user['code'] == 200) {
            $user_id = $res_user['message'];
        }
        $sql = "select id,rcr_meta,name from cluster_meta_info where user_id='$user_id' ";
        $res = $this->Login_model->getList($sql);
        $data['code'] = 200;
        $data['list'] = $res;
        $data['total'] = count($res);
        print_r(json_encode($data));
    }

    public function getStandbyMeta()
    {
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $cluster_id = $string['cluster_id'];
        $this->load->model('Cluster_model');
        //获取rcr的所有集群id
        $sql_cluster_id = "SELECT GROUP_CONCAT(DISTINCT ids SEPARATOR ',')as clusters FROM cluster_rcr_infos t1,(SELECT id,CONCAT(master_cluster_id,',',slave_cluster_id) as ids FROM cluster_rcr_infos  where status!='deleted') t2 WHERE t1.id = t2.id";
        $res_cluster_id = $this->Cluster_model->getList($sql_cluster_id);
        $rcr_cluster_id = '';
        if ($res_cluster_id !== false) {
            $rcr_cluster_id = $res_cluster_id[0]['clusters'];
        }
        $sql = "select id,name,nick_name from db_clusters where  memo!='' and memo is not null and status!='deleted'  ";
        if (!empty($cluster_id)) {
            if (!empty($rcr_cluster_id)) {
                $slave_cluster_id = $rcr_cluster_id . ',' . $cluster_id;
            } else {
                $slave_cluster_id = $cluster_id;
            }
            $sql .= " and id not in($slave_cluster_id)";
        } else {
            if (!empty($rcr_cluster_id)) {
                $sql .= " and id not in($rcr_cluster_id)";
            }
        }
        $res = $this->Cluster_model->getList($sql);
        $data['code'] = 200;
        $data['list'] = $res;
        $data['total'] = count($res);
        print_r(json_encode($data));
    }

    public function createMetaTable()
    {
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $user_name = $string['user_name'];
        $this->load->model('Login_model');
        //查user_id
        $user_sql = "select id from kunlun_user where name='$user_name';";
        $res_user = $this->Login_model->getList($user_sql);
        if (!empty($res_user)) {
            $user_id = $res_user[0]['id'];
        } else {
            $data['code'] = 500;
            $data['message'] = '该用户不存在';
            print_r(json_encode($data));
        }
        //查当前元数据ips
        $this->load->model('Cluster_model');
        $sql_meta = "select id,hostaddr,port from meta_db_nodes ";
        $res_meta = $this->Cluster_model->getList($sql_meta);
        $ips = '';
        foreach ($res_meta as $row => $value) {
            $ip = '';
            $port = '';
            foreach ($value as $key1 => $value1) {
                if ($key1 == 'hostaddr') {
                    $ip = $value1;
                }
                if ($key1 == 'port') {
                    $port = $value1;
                }
            }
            $ips .= $ip . ':' . $port . ',';
        }
        $rcr_meta = substr($ips, 0, strlen($ips) - 1);
        //如不存在创建表

        //先查是否存在此条数据，存在更新 不存在insert
        $select_sql = "select id from cluster_meta_info where name='system'  and user_id='$user_id' and rcr_meta='$rcr_meta'";
        $res_select = $this->Login_model->getList($select_sql);
        if (empty($res_select)) {
            $insert_sql = "insert into cluster_meta_info(user_id,name,rcr_meta) values ('$user_id','system','$rcr_meta'); ";
            $this->Login_model->updateList($insert_sql);
        }
    }

    public function getMetaList()
    {
        $pageNo = $this->input->get('pageNo');
        $pageSize = $this->input->get('pageSize');
        $user_name = $this->input->get('user_name');
        $this->load->model('Login_model');
        $user_id = '';
        $res_user = $this->Login_model->getUserId($user_name);
        if ($res_user['code'] == 200) {
            $user_id = $res_user['message'];
        } else {
            print_r(json_decode($res_user));
        }
        $start = ($pageNo - 1) * $pageSize;
        //获取用户数据
        $sql = "select * from cluster_meta_info where user_id='$user_id' ";
        $sql .= " order by id desc limit " . $pageSize . " offset " . $start;
        $res = $this->Login_model->getList($sql);
        if ($res === false) {
            $res = array();
        }
        $sql_total = "select count(id) as count from cluster_meta_info where user_id='$user_id' ";
        $res_total = $this->Login_model->getList($sql_total);


        foreach ($res as $row => &$value) {

            if ($value['db_type'] == '') {
                $value['db_type'] = 'Klustron';
                $sql = "update cluster_meta_info set db_type='Klustron' where id=?";
                $parma = [$value['id']];
                $this->Login_model->updateList($sql, $parma);
            }

            $value["value"] = $value['rcr_meta'];
            $value["desc"] = $value['rcr_meta'];
            $value["label"] = $value['name'].'('.$value['db_type'].')';


            if ($value['db_type'] == 'Klustron') {


                $ips_arr = explode(',', $value['rcr_meta']);

                $meta_arr = explode(':', $ips_arr[0]);

                $res_meta = $this->getMeta($meta_arr[0], $meta_arr[1]);
                if ($res_meta['code'] == 200) {

                    $cluster_sql = "select * from db_clusters where when_deleted is null ";
                    $res_main = $this->Change_model->getMysqlRes($meta_arr[0], $meta_arr[1], 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $cluster_sql);

                    $tmp = [];

                    foreach ($res_main['list'] as $row => $value_l) {

                        $tmp[] = [
                            "value" => $value_l['name'],
                            "desc" => $value_l['nick_name'],
                            "label" => $value_l['nick_name'],
                        ];
                    }

                    $value['children'] = $tmp;

                }

            }

        }

        $data['code'] = 200;
        $data['list'] = $res;
        $data['total'] = $res_total ? (int)$res_total[0]['count'] : 0;
        print_r(json_encode($data));
    }

    public function setRCRMaxDalay()
    {
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $rcr_id = $string['rcr_id'];
        $maxtime = $string['maxtime'];
        $user_name = $string['user_name'];
        $this->load->model('Login_model');
        //查用户id
        $user_id = '';
        $res_user = $this->Login_model->getUserId($user_name);
        if ($res_user['code'] == 200) {
            $user_id = $res_user['message'];
        } else {
            print_r(json_decode($res_user));
        }

        //先查是否存在此条数据，存在更新 不存在insert
        $select_sql = "select id from rcr_max_dalay where rcr_id='$rcr_id'  and user_id='$user_id'";
        $res_select = $this->Login_model->getList($select_sql);
        if (!empty($res_select)) {
            $update_sql = "update rcr_max_dalay set max_delay_time='$maxtime',update_time=now() where  rcr_id='$rcr_id' and user_id='$user_id'; ";
            $res_update = $this->Login_model->updateList($update_sql);
            if ($res_update == 1) {
                $data['code'] = 200;
                $data['message'] = '设置成功';
            } else {
                $data['code'] = 501;
                $data['message'] = '设置失败';
            }
            print_r(json_encode($data));
        } else {
            $insert_sql = "insert into rcr_max_dalay(rcr_id,user_id,max_delay_time) values ('$rcr_id','$user_id','$maxtime'); ";
            $res_insert = $this->Login_model->updateList($insert_sql);
            if ($res_insert == 1) {
                $data['code'] = 200;
                $data['message'] = '设置成功';
            } else {
                $data['code'] = 501;
                $data['message'] = '设置失败';
            }
            print_r(json_encode($data));
        }
    }

    public function findName()
    {
        //GET请求
        $serve = $_SERVER['QUERY_STRING'];
        $string = preg_split('/[=&]/', $serve);
        $arr = array();
        for ($i = 0; $i < count($string); $i += 2) {
            $arr[$string[$i]] = $string[$i + 1];
        }
        $name = $arr['name'];
        $user_name = $arr['user_name'];
        $this->load->model('Login_model');
        //查用户id
        $user_id = '';
        $res_user = $this->Login_model->getUserId($user_name);
        if ($res_user['code'] == 200) {
            $user_id = $res_user['message'];
        } else {
            print_r(json_decode($res_user));
        }

        $sql_total = "select count(*) as count from cluster_meta_info where user_id='$user_id' and name='$name' ";
        $res_total = $this->Login_model->getList($sql_total);
        $data['code'] = 200;
        $data['total'] = $res_total ? (int)$res_total[0]['count'] : 0;
        print_r(json_encode($data));
    }

    public function addMetaList()
    {
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $user_name = $string['user_name'];
        $ips = $string['ips'];
        $meta_name = $string['meta_name'];
        $db_type = strtolower($string['db_type']);
        $this->load->model('Login_model');
        $res_token = $this->Login_model->getToken($token, 'D', $this->key);
        if (!empty($res_token)) {
            $sql = "select count(id) as count from kunlun_user where name=?";
            $params = [$res_token];
            $res = $this->Login_model->getList($sql, $params);
            if (!empty($res)) {
                if ($res[0]['count'] == 0) {
                    $data['code'] = 500;
                    $data['message'] = 'token错误';
                    print_r(json_encode($data));
                } else {


                    $this->load->model('Cluster_model');

                    $sql_user = "select id from kunlun_user where name=?";
                    $res_user = $this->Login_model->getList($sql_user, [$user_name]);
                    $user_id = $res_user[0]['id'];
                    if (!empty($res_user)) {
                        //查数据是否存在该元数据
                        $select_sql = "select id from cluster_meta_info where  user_id=? and rcr_meta=? and name=?";
                        $params = [$user_id, $ips, $string['db_name']];

                        $res_select = $this->Login_model->getList($select_sql, $params);

                        $db_type = strtolower($db_type);
                        if (empty($res_select)) {
                            if ($db_type == "klustron") {
                                //验证元数据ip端口是否能通
                                $ips_arr = explode(',', $ips);
                                $meta_count = count($ips_arr);
                                foreach ($ips_arr as $knode => $vnode) {
                                    $meta_arr = explode(':', $vnode);
                                    $res_meta = $this->getMeta($meta_arr[0], $meta_arr[1]);
                                    if ($res_meta['code'] == 200) {
                                        break;
                                    } else if ($meta_count == ($knode + 1)) {
                                        $data['code'] = 506;
                                        $data['message'] = $res_meta[0] . $meta_arr[0] . '(' . $meta_arr[1] . ')';
                                        print_r(json_encode($data));
                                        return;
                                    } else {
                                        continue;
                                    }
                                }
                            }

                            $params = [
                                $meta_name,
                                $db_type,
                                $user_id,
                                $ips,
                                $string['db_user'],
                                $string['db_password'],
                                $string['db_name']
                            ];


                            if ($db_type == "mysql") {

                                $sql_main = "show databases";

                                $ipsArr = explode(',', $ips);
                                $res_main = $this->Cluster_model->getMysqlRes($ipsArr[0], $ipsArr[1], $string['db_user'], $string['db_password'], '', $sql_main);

                                if ($res_main['code'] == 500) {
                                    $data['code'] = 506;
                                    $data['message'] = $res_main['message'];
                                    print_r(json_encode($data));
                                    return;
                                }

                            }

                            $sql_update = "INSERT INTO cluster_meta_info(`name`,`db_type`,`user_id`,`rcr_meta`,`db_user`,`db_passwd`,`db_name`) values (?,?,?,?,?,?,?);";


                            $res_update = $this->Login_model->UpDataAddRcrMeta($sql_update, $params);

                            if ($res_update == 1) {
                                $data['code'] = 200;
                                $data['message'] = '新增成功';
                            } else {
                                $data['code'] = 501;
                                $data['message'] = '新增失败' . json_encode($res_update);
                            }
                        } else {
                            $data['code'] = 301;
                            $data['message'] = '该元数据已经在，无需重复添加';
                        }
                        print_r(json_encode($data));
                    } else if ($res_user == false) {
                        $data['code'] = 510;
                        $data['message'] = '该用户不存在';
                        print_r(json_encode($data));
                    } else {
                        $data['code'] = 305;
                        $data['message'] = '系统繁忙';
                        print_r(json_encode($data));
                    }
                }
            }
        } else {
            $data['code'] = 500;
            $data['message'] = 'token错误';
            print_r(json_encode($data));
        }
    }

    public function deleteMeta()
    {
        //获取token
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $id = $string['id'];
        //验证token
        $this->load->model('Login_model');
        $res_token = $this->Login_model->getToken($token, 'D', $this->key);
        if (!empty($res_token)) {
            $sql = "select count(id) as count from kunlun_user where name='$res_token';";
            $res = $this->Login_model->getList($sql);
            if (!empty($res)) {
                if ($res[0]['count'] == 0) {
                    $data['code'] = 500;
                    $data['message'] = 'token错误';
                    print_r(json_encode($data));
                } else {
                    $sql_update = "delete from cluster_meta_info where id='$id';";
                    $res_update = $this->Login_model->updateList($sql_update);
                    if ($res_update == 1) {
                        $data['code'] = 200;
                        $data['message'] = '删除成功';
                    }

                    print_r(json_encode($data));
                }
            }
        } else {
            $data['code'] = 500;
            $data['message'] = 'token错误';
            print_r(json_encode($data));
        }
    }

    public function findMetaDB()
    {
        $this->load->model('Cluster_model');
        $sql = "select hostaddr,port from meta_db_nodes;  ";
        $res = $this->Cluster_model->getList($sql);
        $ips = '';
        if ($res !== false) {
            foreach ($res as $key => $row) {
                $host = $this->Cluster_model->ipTranslation($res[$key]['hostaddr']);
                $ips .= $host . ':' . $res[$key]['port'] . ',';
            }
        }
        $rcr_meta = substr($ips, 0, strlen($ips) - 1);
        $data['code'] = 200;
        $data['ips'] = $rcr_meta;
        $data['res'] = $res;
        print_r(json_encode($data));
    }

    public function findMetaCluster()
    {
        //获取token
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        $string = json_decode(@file_get_contents('php://input'), true);
        $meta = $string['res'];
        $cluster_id = $string['cluster_id'];
        $res = array();
        if (strpos($meta, ',') !== false) {
            //$meta=substr($meta,0,strlen($meta)-1);
            $meta_res = explode(',', $meta);
            $meta_count = count($meta_res);
        } else {
            $meta_res = array('0' => $meta);
            $meta_count = count($meta_res);
        }
        $string = 'cluster_info';
        foreach ($meta_res as $knode => $vnode) {
            $ips = explode(':', $vnode);
            $sql = "select id,name,nick_name from db_clusters where  memo!='' and memo is not null and status!='deleted' ";
            if (!empty($cluster_id)) {
                $sql .= " and id!='$cluster_id'";
            }
            $res_meta = $this->getMetaClusters($ips[0], $ips[1], $sql, $string);
            if ($res_meta['code'] == 200) {
                $res = $res_meta;
                break;
            } else if ($meta_count == ($knode + 1)) {
                $data['code'] = 500;
                $data['message'] = $res_meta[0] . $vnode['hostaddr'] . '(' . $vnode['port'] . ')';
                print_r(json_encode($data));
                return;
            } else {
                continue;
            }
        }
        $data['code'] = $res_meta['code'];
        $data['res'] = $res;
        print_r(json_encode($data));
    }

    public function getMetaClusters($ip, $port, $sql, $string)
    {
        $this->load->model('Change_model');
        $res = $this->Change_model->getAllMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql, $string);
        return $res;
    }

    public function getMetaName($meta, $user)
    {
        $this->load->model('Login_model');
        $sql = "select name from cluster_meta_info where  rcr_meta='$meta';  ";
        $res = $this->Login_model->getList($sql);
        return $res;
    }

    public function getRCRRelater()
    {
        $cluster_id = $this->input->get('cluster_id');
        $this->load->model('Cluster_model');
        $sql = "select count(*) as count from cluster_rcr_infos where status!='deleted' and (master_cluster_id='$cluster_id' or  slave_cluster_id='$cluster_id');  ";
        $res = $this->Cluster_model->getList($sql);
        $data['total'] = $res ? (int)$res[0]['count'] : 0;
        $data['code'] = 200;
        print_r(json_encode($data));
        return;
    }

    public function findRcrRelat()
    {
        $meta_db = $this->input->get('meta_db');
        $this->load->model('Cluster_model');
        $sql = "select count(*) as count from cluster_rcr_infos  where status!='deleted' and (master_rcr_meta='$meta_db' or slave_rcr_meta='$meta_db');";
        $res = $this->Cluster_model->getList($sql);
        $data['code'] = 200;
        $data['total'] = $res ? (int)$res[0]['count'] : 0;
        print_r(json_encode($data));
    }

    public function getMaxDelayTime($rcr_id, $user)
    {
        $this->load->model('Login_model');
        $sql = "select max_delay_time from rcr_max_dalay where user_id='$user' and rcr_id='$rcr_id';  ";
        $res = $this->Login_model->getList($sql);
        return $res;
    }

    public function delRCRMaxDalayInfo()
    {
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $rcr_id = $string['rcr_id'];
        $user_name = $string['user_name'];
        $this->load->model('Login_model');
        //查用户id
        $user_id = '';
        $res_user = $this->Login_model->getUserId($user_name);
        if ($res_user['code'] == 200) {
            $user_id = $res_user['message'];
        } else {
            print_r(json_decode($res_user));
        }
        $this->load->model('Login_model');
        $sqldalay = "select TABLE_NAME from information_schema.TABLES where TABLE_NAME = 'rcr_max_dalay';";
        $resdalay = $this->Login_model->getList($sqldalay);
        if ($resdalay !== false) {
            $update_sql = "delete from rcr_max_dalay  where  rcr_id='$rcr_id' ";
            $res_update = $this->Login_model->updateList($update_sql);
            if ($res_update !== false) {
                $data['code'] = 200;
                $data['message'] = '删除成功';
            } else {
                $data['code'] = 500;
                $data['message'] = '删除失败';
            }
            print_r(json_encode($data));
        }
    }

    public function getMetaSyncList()
    {
        $rcr_id = $this->input->get('rcr_id');
        $this->load->model('Cluster_model');
        $sql = "select * from cluster_rcr_meta_sync where meta_sync_state!='deleted' and rcr_infos_id='$rcr_id';  ";
        $res = $this->Cluster_model->getList($sql);
        $data['code'] = 200;
        $data['list'] = $res;
        $data['total'] = $res ? (int)$res[0]['count'] : 0;
        print_r(json_encode($data));
    }

    public function getMeta($ip, $port)
    {
        $sql = "select hostaddr,port from cluster_mgr_nodes where member_state='source'";
        $this->load->model('Change_model');
        $res = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql);
        return $res;
    }

    public function ifSwitch()
    {
        //GET请求
        $rcr_id = $this->input->get('rcr_id');
        $this->load->model('Cluster_model');
        $sql_total = "select count(*) as count from cluster_rcr_meta_sync where rcr_infos_id='$rcr_id' and meta_sync_state='dump' ";
        $res_total = $this->Cluster_model->getList($sql_total);
        $data['code'] = 200;
        $data['total'] = $res_total ? (int)$res_total[0]['count'] : 0;
        print_r(json_encode($data));
    }

    public function getRCRCluster()
    {
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $metadb = $string['metadb'];
        $cluster_id = $string['cluster_id'];
        //查元数据是否一致
        $slave_meta = $this->getCurrentMeta();
        if ($metadb == $slave_meta) {
            $cluster_name = $this->clusterName($cluster_id);
            if ($cluster_name !== false) {
                $data['cluster_name'] = $cluster_name[0]['nick_name'];
            }
            $sql_shard = "select id,name from shards where db_cluster_id='$cluster_id' and status!='deleted'";
            $res_shard = $this->Cluster_model->getList($sql_shard);
            if ($res_shard === false) {
                $res_shard = array();
            } else {
                foreach ($res_shard as $row => $value) {
                    foreach ($value as $key2 => $value2) {
                        if ($key2 == 'id' && !empty($value2)) {
                            $shard_nodes = $this->shardNodes($value2, $cluster_id);
                            if ($shard_nodes !== false) {
                                $res_shard[$row]['shard_nodes'] = $shard_nodes;
                            } else {
                                $res_shard[$row]['shard_nodes'] = '';
                            }
                        }
                    }
                }
            }
            $data['code'] = 200;
            $data['list'] = $res_shard;
            $data['total'] = $res_shard ? (int)$res_shard[0]['count'] : 0;
            print_r(json_encode($data));
        } else {
            $metadb_arr = explode(',', $metadb);
            $metadb_count = count($metadb_arr);
            $arr = array();
            foreach ($metadb_arr as $k => $v) {
                $ip_arr = explode(':', $v);
                $ip = $ip_arr[0];
                $port = $ip_arr[1];
                $this->load->model('Change_model');
                $sql_cluster = "select nick_name from shards where db_cluster_id='$cluster_id' and status!='deleted'";
                $res_cluster = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_cluster);
                if ($sql_cluster['code'] == 200) {
                    $data['cluster_name'] = $sql_cluster[0];
                }
                $sql_shard = "select id,name from shards where db_cluster_id='$cluster_id' and status!='deleted'";
                $res_shard = $this->Change_model->getAllMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_shard, '');
                $shard_list = $res_shard['list'];
                if ($res_shard['code'] == 200) {
                    foreach ($shard_list as $row => $value) {
                        foreach ($value as $key2 => $value2) {
                            if ($key2 == 'host' && !empty($value2)) {
                                $arr[$row]['id'] = $value2;
                                $shard_nodes = $this->getShardNodes($value2, $cluster_id, $ip, $port);
                                if ($shard_nodes !== false) {
                                    $arr[$row]['shard_nodes'] = $shard_nodes['list'];
                                }
                            }
                            if ($key2 == 'port' && !empty($value2)) {
                                $arr[$row]['name'] = $value2;
                            }
                        }
                    }
                    $data['code'] = 200;
                    $data['list'] = $arr;
                    $data['total'] = $arr ? (int)$arr[0]['count'] : 0;
                    print_r(json_encode($data));
                    break;
                } else if ($metadb_count == ($k + 1)) {
                    $data['code'] = 500;
                    $data['message'] = $res_shard[0];
                    print_r(json_encode($data));
                    return;
                } else {
                    continue;
                }
            }
        }

    }

    public function shardNodes($shard_id, $cluster_id)
    {
        $this->load->model('Cluster_model');
        $sql = "select hostaddr as host,port,status,replica_delay,member_state from shard_nodes where db_cluster_id='$cluster_id' and status!='deleted' and shard_id='$shard_id'";
        $res = $this->Cluster_model->getList($sql);
        return $res;
    }

    public function clusterName($cluster_id)
    {
        $this->load->model('Cluster_model');
        $sql = "select nick_name from db_clusters where id='$cluster_id'";
        $res = $this->Cluster_model->getList($sql);
        return $res;
    }

    public function getShardNodes($shard_id, $cluster_id, $ip, $port)
    {
        $this->load->model('Change_model');
        $string = 'shard_nodes_info';
        $sql = "select hostaddr,port,status,replica_delay,member_state from shard_nodes where db_cluster_id='$cluster_id' and status!='deleted' and shard_id='$shard_id'";
        $res = $this->Change_model->getAllMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql, $string);
        if ($res['code'] !== 200) {
            return false;
        }
        return $res;
    }

    public function getThisRCRCluster($cluster_id, $metadb)
    {
        //查元数据是否一致
        $slave_meta = $this->getCurrentMeta();
        if ($metadb == $slave_meta) {
            $sql = "select name from db_clusters where id='$cluster_id'";
            $res = $this->Cluster_model->getList($sql);
            return $res['name'];
        } else {
            $metadb_arr = explode(',', $metadb);
            $metadb_count = count($metadb_arr);
            foreach ($metadb_arr as $k => $v) {
                $ip_arr = explode(':', $v);
                $ip = $ip_arr[0];
                $port = $ip_arr[1];
                $this->load->model('Change_model');
                $sql = "select name from db_clusters where id='$cluster_id'";
                $res = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql);
                if ($res['code'] == 200) {
                    return $res[0];
                } else if ($metadb_count == ($k + 1)) {
                    return '';
                } else {
                    continue;
                }
            }
        }

    }

    public function getCurrentMeta()
    {
        $this->load->model('Cluster_model');
        $sql = "select hostaddr,port from meta_db_nodes; ";
        $res = $this->Cluster_model->getList($sql);
        $slave_meta = '';
        if ($res !== false) {
            foreach ($res as $key => $row) {
                $ips .= $res[$key]['hostaddr'] . ':' . $res[$key]['port'] . ',';
            }
            $slave_meta = substr($ips, 0, strlen($ips) - 1);
        }
        return $slave_meta;
    }

    public function getCurrentTime()
    {
        //GET请求
        $rcr_id = $this->input->get('rcr_id');
        $metadb = $this->input->get('slave_meta_db');
        $this->load->model('Cluster_model');
        //查元数据是否一致
        $slave_meta = $this->getCurrentMeta();
        if ($metadb == $slave_meta) {
            $sql = "select replica_delay from cluster_rcr_infos where id='$rcr_id'";
            $res = $this->Cluster_model->getList($sql);
            $data['code'] = 200;
            $data['time'] = $res['replica_delay'];
            print_r(json_encode($data));
        } else {
            $metadb_arr = explode(',', $metadb);
            $metadb_count = count($metadb_arr);
            foreach ($metadb_arr as $k => $v) {
                $ip_arr = explode(':', $v);
                $ip = $ip_arr[0];
                $port = $ip_arr[1];
                $this->load->model('Change_model');
                $sql = "select replica_delay from cluster_rcr_infos where id='$rcr_id'";
                $res = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql);
                if ($res['code'] == 200) {
                    $data['code'] = 200;
                    $data['time'] = $res[0];
                    print_r(json_encode($data));
                    break;
                } else if ($metadb_count == ($k + 1)) {
                    $data['code'] = 500;
                    $data['message'] = $res[0];
                    print_r(json_encode($data));
                    return;
                } else {
                    continue;
                }
            }
        }
    }
}
