<?php

class Db_login_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->db = $this->load->database('role', true);
    }

    //查询数据
    public function getList($sql, $paras = [])
    {
        $q = $this->db->query($sql, $paras); //自动转义
        if ($q && $q->num_rows() > 0) {
            $arr = $q->result_array();
            return $arr;
        }
        return false;
        //return $this->db->_error_message();
    }


    //更新数据
    public function updateList($sql, $paras = [])
    {

        //先查看那个是主节点,根据主节点连接数据库todo
        //$mysql="select * from performance_schema.replication_group_members;";
        $this->db->query($sql, $paras);

        $error = $this->db->error();
        if ($error['code'] !== 0) {
            //切换元数据主节点
            $mysql = "select MEMBER_HOST,MEMBER_PORT from performance_schema.replication_group_members where MEMBER_ROLE = 'PRIMARY' and MEMBER_STATE = 'ONLINE'";
            $q = $this->db->query($mysql);
            if ($q->num_rows() > 0) {
                $arr = $q->result_array();
                if (!empty($arr)) {
                    $host = $arr[0]['MEMBER_HOST'];
                    $port = $arr[0]['MEMBER_PORT'];
                    //print_r($host);exit;
                    $f = fopen('./application/config/database.php', 'w+');
                    $file = "<?php
		defined('BASEPATH') OR exit('No direct script access allowed');
		\$active_group = 'default';
		\$query_builder = TRUE;
		\$db_debug=FALSE;
		\$db['role']=array(
			'dsn'	=> '',
			'hostname' => '$host',
			'port' => $port,
			'username' => 'pgx',
			'password' => 'pgx_pwd',
			'database' => 'kunlun_dba_tools_db',
			'dbdriver' => 'mysqli',
			'dbprefix' => '',
			'pconnect' => FALSE,
			'db_debug' => FALSE,
			'cache_on' => FALSE,
			'cachedir' => '',
			'char_set' => 'utf8',
			'dbcollat' => 'utf8_general_ci',
			'swap_pre' => '',
			'encrypt' => FALSE,
			'compress' => FALSE,
			'stricton' => FALSE,
			'failover' => array(),
			'options' => array(PDO::ATTR_TIMEOUT => 5),
			'save_queries' => TRUE,
		);
		\$db['default']=array(
			'dsn'	=> '',
			'hostname' => '$host',
			'port' => $port,
			'username' => 'pgx',
			'password' => 'pgx_pwd',
			'database' => 'kunlun_metadata_db',
			'dbdriver' => 'mysqli',
			'dbprefix' => '',
			'pconnect' => FALSE,
			'db_debug' => FALSE,
			'cache_on' => FALSE,
			'cachedir' => '',
			'char_set' => 'utf8',
			'dbcollat' => 'utf8_general_ci',
			'swap_pre' => '',
			'encrypt' => FALSE,
			'compress' => FALSE,
			'stricton' => FALSE,
			'failover' => array(),
			'options' => array(PDO::ATTR_TIMEOUT => 5),
			'save_queries' => TRUE,
		);";
                    fwrite($f, $file);
                    fgets($f);
                    $this->db->query($sql);
                    return $this->db->affected_rows();
                } else {
                    return $this->db->error();
                }
            } else {

            }
            //return $error;
        }
        return $this->db->affected_rows();
    }


    public function createTable()
    {

        $sql = "CREATE TABLE IF NOT EXISTS kunlun_dba_tools_db.auto_customer_service (id int unsigned NOT NULL AUTO_INCREMENT,hostaddr varchar(8192) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,port int unsigned DEFAULT NULL,PRIMARY KEY (id)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;";
        $this->updateList($sql);


        $sql = "CREATE TABLE IF NOT EXISTS kunlun_dba_tools_db.cluster_meta_info (id INT UNSIGNED NOT NULL AUTO_INCREMENT,user_id INT UNSIGNED NOT NULL,`name` VARCHAR (120) DEFAULT NULL,rcr_meta VARCHAR (255) COLLATE utf8mb4_0900_as_cs DEFAULT '',db_type VARCHAR (64) COLLATE utf8mb4_0900_as_cs DEFAULT '',when_created TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,update_time TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (id)) ENGINE=INNODB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;";
        $this->updateList($sql);


        $sql_table = "CREATE TABLE IF NOT EXISTS kunlun_dba_tools_db.shard_max_dalay (id int unsigned NOT NULL AUTO_INCREMENT,shard_id int unsigned NOT NULL,db_cluster_id int unsigned NOT NULL,user_id int unsigned NOT NULL,max_delay_time int NOT NULL DEFAULT '100',when_created timestamp NULL DEFAULT CURRENT_TIMESTAMP,update_time timestamp NULL DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (id)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;";
        $this->updateList($sql_table);

    }


    public function AlterTable()
    {
        $db_type_sql = "ALTER TABLE cluster_meta_info ADD COLUMN `db_type` varchar(64) NOT NULL ";
        $this->db->query($db_type_sql);


        $db_user_sql = "ALTER TABLE cluster_meta_info ADD COLUMN `db_user` varchar(64) NULL  ";
        $this->db->query($db_user_sql);


        $db_passwd_sql = "ALTER TABLE cluster_meta_info ADD COLUMN `db_passwd` varchar(255) NULL";
        $this->db->query($db_passwd_sql);


        $db_name_sql = "ALTER TABLE cluster_meta_info ADD COLUMN `db_name` varchar(255) NULL ";
        $this->db->query($db_name_sql);

    }

}
