package database

type CompNode struct {
	ID               uint   `gorm:"primaryKey;autoIncrement:false" json:"id"`
	Name             string `gorm:"size:64;not null" json:"name"`
	HostAddr         string `gorm:"size:8192;not null" json:"hostaddr"`
	Port             uint16 `gorm:"not null" json:"port"`
	MySQLPort        uint16 `gorm:"not null" json:"mysql_port"`
	DBClusterID      uint   `gorm:"not null" json:"db_cluster_id"`
	UserName         string `gorm:"size:64;not null" json:"user_name"`
	Passwd           string `gorm:"size:16;not null" json:"passwd"`
	Status           string `gorm:"type:enum('creating','inactive','active','deleted','manual_stop');default:'creating'" json:"status"`
	SvrNodeID        uint   `gorm:"not null" json:"svr_node_id"`
	CPUCores         uint16 `gorm:"default:0" json:"cpu_cores"`
	CPULimitMode     string `gorm:"type:enum('share','quota');default:'share'" json:"cpu_limit_mode"`
	MaxMemMB         uint   `gorm:"default:0" json:"max_mem_MB"`
	MaxConns         uint   `gorm:"default:0" json:"max_conns"`
	ExtraProps       string `gorm:"type:text" json:"extra_props,omitempty"`
	ColdBackupPeriod string `gorm:"size:50;not null;default:'01:00:00-02:00:00'" json:"coldbackup_period"`
	WhenDeleted      string `gorm:"size:24" json:"when_deleted,omitempty"`
	WhenCreated      string `gorm:"size:24" json:"when_created,omitempty"`
}

type CompNodeSearch struct {
	ID           int
	Name         string
	HostAddr     string
	Port         string
	MySQLPort    string
	UserName     string
	Passwd       string
	DBClusterID  int
	SvrNodeID    int
	Status       string
	MaxConns     int
	MaxMemMB     int
	CPUCores     int
	CPULimitMode string
}

func (CompNode) TableName() string {
	return "comp_nodes"
}
