<?php
defined('BASEPATH') or exit('No direct script access allowed');
require_once 'vendor/autoload.php';


class Login extends CI_Controller
{
    // 定义类属性
    public $Login_model;
    public $Change_model;
    public $Cluster_model;
    private $config_items = array();
    private $key;
    private $grafana_key;
    private $grafana_svr;
    private $post_url;
    private $saas_server;
    private $CI;

    public function __construct()
    {
        parent::__construct();

        // 设置响应头
        header('Access-Control-Allow-Origin:*');
        header('Access-Control-Allow-Headers: Content-Type,Content-Length,Accept-Encoding,X-Requested-with, Origin');
        header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE');
        header('Access-Control-Allow-Headers:x-requested-with,content-type,Token');
        header('Content-Type: application/json;charset=utf-8');

        // 获取 CI 实例
        $this->CI =& get_instance();
        
        // 加载配置
        $this->CI->load->config('myconfig', TRUE);
        $this->config_items = $this->CI->config->item('myconfig');
        
        // 加载模型
        $this->load->model('Login_model');
        $this->load->model('Change_model');
        $this->load->model('Cluster_model');

        // 初始化配置项
        if(is_array($this->config_items)) {
            $this->key = isset($this->config_items['key']) ? $this->config_items['key'] : '';
            $this->grafana_key = isset($this->config_items['grafana_key']) ? $this->config_items['grafana_key'] : '';
            $this->grafana_svr = isset($this->config_items['grafana_svr']) ? $this->config_items['grafana_svr'] : '';
            $this->post_url = isset($this->config_items['post_url']) ? $this->config_items['post_url'] : '';
            $this->saas_server = isset($this->config_items['saas_server']) ? $this->config_items['saas_server'] : '';
        }
    }

    private function loadMeta()
    {
        $string = file_get_contents('./json/meta.json');
        $data = json_decode($string, true);
        return $data;
    }


    // 获取当前的定时任务
    function getScheduledTasks($crontabFile)
    {
        if (!file_exists($crontabFile)) {
            return [];
        }

        $tasks = file($crontabFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        return $tasks;
    }


    // 设置新的定时任务
    function setScheduledTasks($configFile, $crontabFile): void
    {
        // 读取配置文件
        $config = json_decode(file_get_contents($configFile), true);
        if ($config === null) {
            die("Failed to parse config file.");
        }
        // 获取当前的 crontab 内容
        $currentCrontab = $this->getScheduledTasks($crontabFile);
        $currentCrontabString = implode("\n", $currentCrontab) . "\n";

        // 初始化一个标记，判断是否有新的任务
        $hasNewTasks = false;

        // 遍历配置中的定时任务
        foreach ($config['jobs'] as $job) {
            $schedule = $job['schedule'];
            $command = $job['command'];
            $cronJob = "{$schedule} {$command}\n";

            // 检查当前 crontab 中是否已存在此任务
            if (strpos($currentCrontabString, $cronJob) === false) {
                // 如果任务不存在，标记为有新任务
                $hasNewTasks = true;
                // 将新任务添加到当前任务中
                $currentCrontabString .= $cronJob;
            }
        }
        // 如果有新任务，更新 crontab
        if ($hasNewTasks) {
//            if (!is_writable($crontabFile)) {
//                echo "File is not writable.";
//            }
            file_put_contents($crontabFile, $currentCrontabString);
        }
    }



    public function getMT()
    {
        require_once './application/helpers/src/Client.php';


        require_once './application/helpers/src/Contract/RequestInterface.php';

        require_once './application/helpers/src/Exception/JsonInvalidArgumentException.php';
        require_once './application/helpers/src/Exception/ParamNotFoundException.php';
        require_once './application/helpers/src/Exception/ResultErrorException.php';


        require_once './application/helpers/src/Utils/MtUtilJson.php';
        require_once './application/helpers/src/Utils/SignUtil.php';


        require_once './application/helpers/src/Requests/AbstractRequest.php';
        require_once './application/helpers/src/Requests/ApiQueryCouponRequest.php';


        $client = new \Msmm\MtMtz\Client();
        $client->setAppKey('2c418bab9d8a4f2ab61415d5dbb3eba9');
        $client->setSecret('057caae17985425094cc71c16c63ba9d');


        $request = new \Msmm\MtMtz\Requests\ApiQueryCouponRequest();
        $request->setLongitude(113046048);
        $request->setLatitude(25286374);
        $request->setPlatform(1);
//        $request->setBizLine(2);
        $request->setListTopiId(3);
        $request->setPageSize(20);

        $rs = $client->execute($request);

        pae($rs);


    }


    public function getModel()
    {



        $meta = $this->loadMeta();


        $ip = "";
        $port = "";
        $saas = 0;

        $host = $this->saas_server;
        $port = 8888;
        // 尝试连接端口
        $connection = @fsockopen($host, $port);
        // 检查连接是否成功
        if ($connection) {
            fclose($connection);
        } else {

            if (count($meta) > 0) {
                $ip = $meta['nodes'][0]['ip'];
                $port = $meta['nodes'][0]['port'];
                $saas = $meta['saas'];
            }

            //获取元数据的主节点
            $sql_main = "select hostaddr,port from meta_db_nodes where member_state='source'";
            $res_main = $this->Cluster_model->getMysqlRes($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_main);

            if ($res_main['code'] == 200 &&  $res_main['list']) {
                $ip = $res_main['list'][0]['hostaddr'];
                $port = $res_main['list'][0]['port'];

                $configpath = "./application/config/config_tpl.yaml";
                $config = file_get_contents($configpath);
                $config = str_replace('{{server_ip_str}}', $ip, $config);
                $config = str_replace('{{server_port_str}}', $port, $config);
                $config = str_replace('{{server_saas_str}}', $saas, $config);
                file_put_contents("./config.yaml", $config);
                sleep(1);

                $command = $_SERVER['DOCUMENT_ROOT'] . '/KunlunMonitor/saas_server_x86_64 > /dev/null 2>&1 &';
                exec($command, $output, $returnCode);

                try {

                    $file = "<?php
        defined('BASEPATH') OR exit('No direct script access allowed');
        \$active_group = 'default';
        \$query_builder = TRUE;
        \$db_debug=FALSE;
        \$db['role']=array(
          'dsn'	=> '',
          'hostname' => '$ip',
          'port' => $port,
          'username' => 'pgx',
          'password' => 'pgx_pwd',
          'database' => 'kunlun_dba_tools_db',
          'dbdriver' => 'mysqli',
          'dbprefix' => '',
          'pconnect' => FALSE,
          'db_debug' => FALSE,
          'cache_on' => FALSE,
          'cachedir' => '',
          'char_set' => 'utf8',
          'dbcollat' => 'utf8_general_ci',
          'swap_pre' => '',
          'encrypt' => FALSE,
          'compress' => FALSE,
          'stricton' => FALSE,
          'failover' => array(),
          'options' => array(PDO::ATTR_TIMEOUT => 5),
          'save_queries' => TRUE,
        );
        \$db['default']=array(
          'dsn'	=> '',
          'hostname' => '$ip',
          'port' => $port,
          'username' => 'pgx',
          'password' => 'pgx_pwd',
          'database' => 'kunlun_metadata_db',
          'dbdriver' => 'mysqli',
          'dbprefix' => '',
          'pconnect' => FALSE,
          'db_debug' => FALSE,
          'cache_on' => FALSE,
          'cachedir' => '',
          'char_set' => 'utf8',
          'dbcollat' => 'utf8_general_ci',
          'swap_pre' => '',
          'encrypt' => FALSE,
          'compress' => FALSE,
          'stricton' => FALSE,
          'failover' => array(),
          'options' => array(PDO::ATTR_TIMEOUT => 5),
          'save_queries' => TRUE,
        );";
                    file_put_contents("./application/config/database.php", $file);
                } catch (Exception $exception) {
                    print_r($exception->getMessage());
                    //return false;
                }
            }
        }

        $data = $this->loadMeta();
        $this->load->model('Login_model');
        $sql = "select * from kunlun_user where name='super_dba'";
        $res = $this->Login_model->getList($sql);

        if (!empty($res)) {
            $user = $res[0];
            if ($user['supper_admin'] == '') {
                $sql_update = "update kunlun_user set supper_admin=1,update_time=now(),main_user=1 where name='super_dba'";
                $res_update = $this->Login_model->updateList($sql_update);
            }
        }

//        $configFile = './json/crontab.json';
//        $crontabFile = '/etc/cron.d/docker_crontab';
//
//        $this->setScheduledTasks($configFile, $crontabFile);
//
//        $res= $this->getScheduledTasks($crontabFile);

        if (isset($data['saas'])) {
            $json['model'] = $data['saas'];
            $json['code'] = 200;
            print_r(json_encode($json));
        } else {
            $json['model'] = 0;
            $json['code'] = 200;
            print_r(json_encode($json));
        }
    }

    public function userCheck()
    {
        $string = json_decode(@file_get_contents('php://input'), true);
        $user_name = $string['username'];
        $password = $string['password'];
        if (empty($user_name) || empty($password)) {
            $data['code'] = 401;
            $data['message'] = '账户或密码不能为空';
            print_r(json_encode($data));
            return;
        }
        //验证用户名和密码
        $this->load->model('Login_model');
        if ($user_name == 'super_dba' && $password == 'super_dba') {
            $sql_super = "select count(id) as count,id from kunlun_user where name='$user_name' and password='$password';";
            $res_super = $this->Login_model->getList($sql_super);
            if ($res_super[0]['count'] == 1) {
                $token = $this->Login_model->getToken($user_name, 'E', $this->key);
                $data['Token'] = $token;
                $data['num'] = 2;
                $data['code'] = 200;
                $data['userName'] = $user_name;
                $data['message'] = '修改密码';
                print_r(json_encode($data));
                return;
            }
        }

        $saas = $this->loadMeta();

        if (isset($saas['saas']) && ($saas['saas'] > 0)) {
            $sql = "select id,supper_admin,main_user,pid from kunlun_user where name='$user_name' and password='$password';";
        } else {
            $sql = "select * from kunlun_user where name='$user_name' and password='$password';";
        }

        $res = $this->Login_model->getList($sql);
        if ($res !== false) {
            $user_count = count($res);
            if ($user_count > 1) {
                $token = $this->Login_model->getToken($user_name, 'E', $this->key);
                $data['Token'] = $token;
                $data['num'] = $user_count;
                $data['code'] = 301;
                $data['message'] = '用户重复';
                print_r(json_encode($data));
            } elseif ($user_count == 1) {
                $userId = $res[0]['id'];
                //获取角色id
                $sql_role = "select role_id,apply_all_cluster,affected_clusters from kunlun_role_assign where user_id='$userId' and valid_period='permanent' ";
                $sql_role .= " union select role_id,apply_all_cluster,affected_clusters from kunlun_role_assign where user_id='$userId' and valid_period='from_to' and start_ts is not null and start_ts<now() and end_ts is null";
                $sql_role .= " union select role_id,apply_all_cluster,affected_clusters from kunlun_role_assign where user_id='$userId' and valid_period='from_to' and end_ts is not null and end_ts>now() and start_ts is null";
                $sql_role .= " union select role_id,apply_all_cluster,affected_clusters from kunlun_role_assign where user_id='$userId' and valid_period='from_to' and end_ts is not null  and start_ts is not null and start_ts<now() and end_ts>now();";
                $res_role = $this->Login_model->getList($sql_role);
                $token = $this->Login_model->getToken($user_name, 'E', $this->key);
                $apply_all_cluster = '';
                $affected_clusters = '';
                if (!empty($res_role)) {
                    //如果只有一条数据
                    $role_count = count($res_role);
                    $arr = array();
                    if ($role_count == 1) {
                        $role_id = $res_role[0]['role_id'];
                        $apply_all_cluster = $res_role[0]['apply_all_cluster'];
                        $affected_clusters = $res_role[0]['affected_clusters'];
                    } elseif ($role_count > 1) {
                        $role_id = '';
                        foreach ($res_role as $key => $row) {
                            foreach ($row as $key2 => $value2) {
                                if ($key2 == 'role_id') {
                                    if (!empty($value2)) {
                                        $role_id .= $value2 . ',';
                                    }
                                }
                                //应用集群，求并集
                                if ($key2 == 'apply_all_cluster') {
                                    if (!empty($value2) && $value2 == 1) {
                                        $apply_all_cluster = $row['apply_all_cluster'];
                                        $affected_clusters = $row['affected_clusters'];
                                        break;
                                    } elseif (!empty($value2) && $value2 == 2) {
                                        $apply_all_cluster = $row['apply_all_cluster'];
                                        $affected_clusters .= $row['affected_clusters'] . ',';
                                    }
                                }
                            }
                        }
                        $role_id = substr($role_id, 0, -1);
                    }
                    //获取该用户权限（多条记录求并集）
                    $sql_priv = "select user_add_priv,user_drop_priv,user_grant_priv,user_edit_priv,role_add_priv,role_drop_priv,role_edit_priv,machine_priv,cluster_creata_priv,cluster_drop_priv,shard_create_priv,shard_drop_priv,storage_node_create_priv,storage_node_drop_priv,compute_node_create_priv,compute_node_drop_priv,machine_add_priv,machine_drop_priv,backup_service_enable_priv,backup_service_disable_priv,storage_enable_priv,storage_disable_priv,compute_enable_priv,compute_disable_priv,backup_priv,restore_priv,expand_cluster_priv,shrink_cluster_priv from kunlun_role_privilege where id in($role_id);";
                    $res_priv = $this->Login_model->getList($sql_priv);
                    if (!empty($res_priv)) {
                        $priv_count = count($res_priv);
                        if ($priv_count == 1) {
                            $data['priv'] = $res_priv[0];
                        } elseif ($priv_count > 1) {
                            $arr = array();
                            //初始化
                            $user_add_priv = 'N';
                            $user_drop_priv = 'N';
                            $user_edit_priv = 'N';
                            $user_grant_priv = 'N';
                            $role_add_priv = 'N';
                            $role_drop_priv = 'N';
                            $role_edit_priv = 'N';
                            $cluster_creata_priv = 'N';
                            $cluster_drop_priv = 'N';
                            $backup_priv = 'N';
                            $restore_priv = 'N';
                            $expand_cluster_priv = 'N';
                            $shrink_cluster_priv = 'N';
                            $storage_node_create_priv = 'N';
                            $storage_node_drop_priv = 'N';
                            $storage_enable_priv = 'N';
                            $storage_disable_priv = 'N';
                            $shard_create_priv = 'N';
                            $shard_drop_priv = 'N';
                            $compute_node_create_priv = 'N';
                            $compute_node_drop_priv = 'N';
                            $compute_enable_priv = 'N';
                            $compute_disable_priv = 'N';
                            $machine_add_priv = 'N';
                            $machine_priv = 'N';
                            $machine_drop_priv = 'N';
                            $backup_service_enable_priv = 'N';
                            $backup_service_disable_priv = 'N';
                            foreach ($res_priv as $key => $value) {
                                foreach ($value as $key2 => $value2) {
                                    if ($key2 == 'user_add_priv') {
                                        if ($value2 == 'Y') {
                                            $user_add_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'user_drop_priv') {
                                        if ($value2 == 'Y') {
                                            $user_drop_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'user_edit_priv') {
                                        if ($value2 == 'Y') {
                                            $user_edit_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'user_grant_priv') {
                                        if ($value2 == 'Y') {
                                            $user_grant_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'role_add_priv') {
                                        if ($value2 == 'Y') {
                                            $role_add_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'role_drop_priv') {
                                        if ($value2 == 'Y') {
                                            $role_drop_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'role_edit_priv') {
                                        if ($value2 == 'Y') {
                                            $role_edit_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'cluster_creata_priv') {
                                        if ($value2 == 'Y') {
                                            $cluster_creata_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'cluster_drop_priv') {
                                        if ($value2 == 'Y') {
                                            $cluster_drop_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'backup_priv') {
                                        if ($value2 == 'Y') {
                                            $backup_priv = $value2;

                                        }
                                    }
                                    if ($key2 == 'restore_priv') {
                                        if ($value2 == 'Y') {
                                            $restore_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'expand_cluster_priv') {
                                        if ($value2 == 'Y') {
                                            $expand_cluster_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'shrink_cluster_priv') {
                                        if ($value2 == 'Y') {
                                            $shrink_cluster_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'expand_cluster_priv') {
                                        if ($value2 == 'Y') {
                                            $expand_cluster_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'storage_node_create_priv') {
                                        if ($value2 == 'Y') {
                                            $storage_node_create_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'storage_node_drop_priv') {
                                        if ($value2 == 'Y') {
                                            $storage_node_drop_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'storage_enable_priv') {
                                        if ($value2 == 'Y') {
                                            $storage_enable_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'storage_enable_priv') {
                                        if ($value2 == 'Y') {
                                            $storage_enable_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'storage_disable_priv') {
                                        if ($value2 == 'Y') {
                                            $storage_disable_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'shard_create_priv') {
                                        if ($value2 == 'Y') {
                                            $shard_create_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'shard_drop_priv') {
                                        if ($value2 == 'Y') {
                                            $shard_drop_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'compute_node_create_priv') {
                                        if ($value2 == 'Y') {
                                            $compute_node_create_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'compute_node_drop_priv') {
                                        if ($value2 == 'Y') {
                                            $compute_node_drop_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'compute_enable_priv') {
                                        if ($value2 == 'Y') {
                                            $compute_enable_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'compute_disable_priv') {
                                        if ($value2 == 'Y') {
                                            $compute_disable_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'machine_add_priv') {
                                        if ($value2 == 'Y') {
                                            $machine_add_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'machine_priv') {
                                        if ($value2 == 'Y') {
                                            $machine_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'machine_drop_priv') {
                                        if ($value2 == 'Y') {
                                            $machine_drop_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'backup_service_enable_priv') {
                                        if ($value2 == 'Y') {
                                            $backup_service_enable_priv = $value2;
                                        }
                                    }
                                    if ($key2 == 'backup_service_disable_priv') {
                                        if ($value2 == 'Y') {
                                            $backup_service_disable_priv = $value2;
                                        }
                                    }
                                }
                            }
                            $arr['user_add_priv'] = $user_add_priv;
                            $arr['user_drop_priv'] = $user_drop_priv;
                            $arr['user_edit_priv'] = $user_edit_priv;
                            $arr['user_grant_priv'] = $user_grant_priv;
                            $arr['role_add_priv'] = $role_add_priv;
                            $arr['role_drop_priv'] = $role_drop_priv;
                            $arr['role_edit_priv'] = $role_edit_priv;
                            $arr['cluster_creata_priv'] = $cluster_creata_priv;
                            $arr['cluster_drop_priv'] = $cluster_drop_priv;
                            $arr['backup_priv'] = $backup_priv;
                            $arr['restore_priv'] = $restore_priv;
                            $arr['expand_cluster_priv'] = $expand_cluster_priv;
                            $arr['shrink_cluster_priv'] = $shrink_cluster_priv;
                            $arr['storage_node_create_priv'] = $storage_node_create_priv;
                            $arr['storage_node_drop_priv'] = $storage_node_drop_priv;
                            $arr['storage_enable_priv'] = $storage_enable_priv;
                            $arr['storage_disable_priv'] = $storage_disable_priv;
                            $arr['shard_create_priv'] = $shard_create_priv;
                            $arr['shard_drop_priv'] = $shard_drop_priv;
                            $arr['compute_node_create_priv'] = $compute_node_create_priv;
                            $arr['compute_node_drop_priv'] = $compute_node_drop_priv;
                            $arr['compute_enable_priv'] = $compute_enable_priv;
                            $arr['compute_disable_priv'] = $compute_disable_priv;
                            $arr['machine_add_priv'] = $machine_add_priv;
                            $arr['machine_priv'] = $machine_priv;
                            $arr['machine_drop_priv'] = $machine_drop_priv;
                            $arr['backup_service_enable_priv'] = $backup_service_enable_priv;
                            $arr['backup_service_disable_priv'] = $backup_service_disable_priv;
                            $data['priv'] = $arr;
                        }
                    }
                    if ($affected_clusters != null) {
                        $affected_clusters = rtrim($affected_clusters, ',');
                    }

                    //字符串去重
                    $affected_clusters = $this->unique($affected_clusters);
                    $data['Token'] = $token;
                    $data['code'] = 200;
                    $data['num'] = 1;
                    $data['userName'] = $user_name;
                    $data['supper_admin'] = isset($res[0]['supper_admin']) ? $res[0]['supper_admin'] : 1;
                    $data['main_user'] = isset($res[0]['main_user']) ? $res[0]['main_user'] : 1;
                    $data['apply_all_cluster'] = $apply_all_cluster;
                    $data['affected_clusters'] = $affected_clusters;
                    $data['message'] = 'success';
                    print_r(json_encode($data));
                } else {
                    $data['code'] = 402;
                    $data['message'] = '该用户未授权，没有登录权限';
                    print_r(json_encode($data));
                }
            } else {
                $data['code'] = 501;
                $data['message'] = '账户或密码错误';
                print_r(json_encode($data));
            }
        } else {
            $data['code'] = 501;
            $data['message'] = '账户或密码错误';
            print_r(json_encode($data));
        }
    }

    public function changePassword()
    {
        header('content-type: application/json; charset=utf-8');
        //获取token
        $arr = apache_request_headers(); //获取请求头数组
        //print_r($arr) ;exit;//输出Token
        $token = $arr["Token"];
        if (empty($token)) {
            $data['code'] = 201;
            $data['message'] = 'token不能为空';
            print_r(json_encode($data));
            return;
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        $user_name = $string['username'];
        $password = $string['password'];
        if (empty($user_name) || empty($password)) {
            $data['code'] = 201;
            $data['message'] = '账户或密码不能为空';
            print_r(json_encode($data));
            return;
        }
        //验证token
        $this->load->model('Login_model');
        $res_token = $this->Login_model->getToken($token, 'D', $this->key);
        if (!empty($res_token)) {
            $sql = "select count(id) as count from kunlun_user where name='$res_token';";
            $res = $this->Login_model->getList($sql);
            if (!empty($res)) {
                if ($res[0]['count'] == 0) {
                    $data['code'] = 500;
                    $data['message'] = 'token错误';
                    print_r(json_encode($data));
                    return;
                } else {
                    //验证用户名是否存在
                    $sql_user = "select count(id) as count from kunlun_user where name='$user_name' and password='$password'";
                    $res_user = $this->Login_model->getList($sql_user);
                    if (!empty($res_user)) {
                        if ($res_user[0]['count'] == 0) {
                            $sql_update = "update kunlun_user set password='$password' where name='$user_name';";
                            $res_update = $this->Login_model->updateList($sql_update);
                            if ($res_update == 1) {
                                $data['code'] = 200;
                                $data['message'] = '修改密码成功';
                            } else {
                                $data['code'] = 501;
                                $data['message'] = '修改密码失败';
                            }
                        } elseif ($res_user[0]['count'] == 1) {
                            $data['code'] = 500;
                            $data['message'] = '新旧密码不能一致';
                        } else {
                            $data['code'] = 501;
                            $data['message'] = '存在多条相同的账户数据';
                        }
                        print_r(json_encode($data));
                    } else {
                        $data['code'] = 500;
                        $data['message'] = '账户或密码错误';
                        print_r(json_encode($data));
                    }
                }
            }
        } else {
            $data['code'] = 500;
            $data['message'] = 'token错误';
            print_r(json_encode($data));
        }
    }

    public function unique($str)
    {
        if ($str == null) {
            return $str;
        }
        $arr = explode(',', $str);
        $arr = array_unique($arr); //内置数组去重算法
        $data = implode(',', $arr);
        $data = trim($data, ','); //trim — 去除字符串首尾处的空白字符
        return $data;
    }

    public function modifyParam()
    {
        try {
            // 获取 POST 数据
            $raw_input = file_get_contents('php://input');
            $postData = json_decode($raw_input, true);
            
            // 记录请求数据
            log_message('debug', 'ModifyParam request data: ' . $raw_input);

            // 验证数据格式
            if (empty($postData) || !is_array($postData)) {
                throw new Exception('Invalid request format');
            }

            // 验证必需参数
            if (!isset($postData['user_name']) || empty($postData['user_name']) || 
                !isset($postData['job_type']) || empty($postData['job_type'])) {
                throw new Exception('Missing required parameters: user_name and job_type are required');
            }

            // 根据 job_type 处理不同的操作
            switch ($postData['job_type']) {
                case 'get_meta_master':
                    // 获取元数据主节点信息
                    $meta_info = $this->getMeta($postData['user_name'], $postData['timestamp']);
                    if (!$meta_info) {
                        throw new Exception('Failed to get meta master info');
                    }
                    
                    // 返回成功响应
                    $response = array(
                        'code' => 200,
                        'message' => 'Success',
                        'data' => $meta_info
                    );
                    break;
                    
                default:
                    throw new Exception('Unsupported job type: ' . $postData['job_type']);
            }
        } catch (Exception $e) {
            log_message('error', 'ModifyParam error: ' . $e->getMessage());
            $response = array(
                'code' => 500,
                'message' => $e->getMessage()
            );
        }

        // 设置响应头
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($response);
    }

    private function cUrlData($url, $data)
    {
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $this->saas_server . $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $data,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                ),
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    private function updataConfigFile($data)
    {

        $saas = $this->loadMeta();
        if (isset($saas['saas'])) {
            $data['saas'] = (string)$saas['saas'];
        }

        try {
            $this->cUrlData('/base/update-config', json_encode($data));
        } catch (Exception $exception) {

        }

        $host=$data['master_ip'];
        $port=$data['master_port'];
        try {
            $f = fopen('./application/config/database.php', 'w+');
            $file = "<?php
		defined('BASEPATH') OR exit('No direct script access allowed');
		\$active_group = 'default';
		\$query_builder = TRUE;
		\$db_debug=FALSE;
		\$db['role']=array(
			'dsn'	=> '',
			'hostname' => '$host',
			'port' => $port,
			'username' => 'pgx',
			'password' => 'pgx_pwd',
			'database' => 'kunlun_dba_tools_db',
			'dbdriver' => 'mysqli',
			'dbprefix' => '',
			'pconnect' => FALSE,
			'db_debug' => FALSE,
			'cache_on' => FALSE,
			'cachedir' => '',
			'char_set' => 'utf8',
			'dbcollat' => 'utf8_general_ci',
			'swap_pre' => '',
			'encrypt' => FALSE,
			'compress' => FALSE,
			'stricton' => FALSE,
			'failover' => array(),
			'options' => array(PDO::ATTR_TIMEOUT => 5),
			'save_queries' => TRUE,
		);
		\$db['default']=array(
			'dsn'	=> '',
			'hostname' => '$host',
			'port' => $port,
			'username' => 'pgx',
			'password' => 'pgx_pwd',
			'database' => 'kunlun_metadata_db',
			'dbdriver' => 'mysqli',
			'dbprefix' => '',
			'pconnect' => FALSE,
			'db_debug' => FALSE,
			'cache_on' => FALSE,
			'cachedir' => '',
			'char_set' => 'utf8',
			'dbcollat' => 'utf8_general_ci',
			'swap_pre' => '',
			'encrypt' => FALSE,
			'compress' => FALSE,
			'stricton' => FALSE,
			'failover' => array(),
			'options' => array(PDO::ATTR_TIMEOUT => 5),
			'save_queries' => TRUE,
		);";

            fwrite($f, $file);
            fgets($f);


        } catch (Exception $exception) {
        }

    }

    public function getRbrMain($ip, $port, $sql)
    {
        $this->load->model('Change_model');
        $res = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql);
        $res_count = count($res);
        $data['list'] = $res;
        $data['count'] = $res_count;
        return $data;
    }

    public function getMeta($ip, $port): array
	{
        $this->load->model('Change_model');
        $this->load->model('Cluster_model');
        //先查主是否通,不通才遍历
        $sql_master = "select hostaddr,port from cluster_mgr_nodes where member_state='source'";
        $res_master = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_master);
        if ($res_master['code'] == 200) {
            $host = $this->Cluster_model->ipTranslation($res_master[0]);
            $cluster_mgr_result = $this->getClusterMgrMaster($host, $res_master[1]);
            if ($cluster_mgr_result === true) {
                $data[0] = $host;
                $data[1] = $res_master[1];
                $data['code'] = 200;
            } else {
                $sql = "select hostaddr,port from cluster_mgr_nodes where hostaddr!='$res_master[0]' or port!='$res_master[1]'";
                $res = $this->Change_model->getAllMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql, '');
                //遍历cluster_mgr找http可连通端口
                if ($res['code'] == 200) {
                    if (!empty($res['list'])) {
                        $res_count = count($res['list']);
                        foreach ($res['list'] as $k => $v) {
                            $cluster_mgr_result = $this->getClusterMgrMaster($host, $v['port']);
                            if ($cluster_mgr_result === true) {
                                $data[0] = $host;
                                $data[1] = $v['port'];
                                $data['code'] = 200;
                                break;
                            } else if ($res_count == ($k + 1)) {
                                $data['code'] = 500;
                                $data[0] = 'Check whether cluster_mgr_nodes table ports in the metadata can send HTTP requests ';
                            } else {
                                continue;
                            }
                        }
                    } else {
                        $data['code'] = 500;
                        $data[0] = 'Check whether cluster_mgr_nodes table ports in the metadata can send HTTP requests ' . $res_master[0] . '(' . $res_master[1] . ')';
                    }
                } else {
                    $data['code'] = $res['code'];
                    $data[0] = $res[0] . $ip . '(' . $port . ')';
                }
            }
        } else {
            $data['code'] = $res_master['code'];
            $data[0] = $res_master[0] . $ip . '(' . $port . ')';
        }
        return $data;
    }

    public function getClusterMgrMaster($ip, $port): bool
	{
        $url = 'http://' . $ip . ':' . $port . '/HttpService/Emit';
        $httpcode = 0;
        $ch = curl_init();
        $timeout = 0.1; // 设置超时的时间[单位：秒]
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_exec($ch);
        # 获取状态码赋值
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($httpcode == 200) {
            return true;
        } else {
            return false;
        }
    }

    public function getMetaMaster($post_string, $post_url)
    {
        $this->load->model('Change_model');
        $post_data = str_replace("\\/", "/", json_encode($post_string));

        $post_arr = $this->Change_model->postData($post_data, $post_url);
        $post_arr = json_decode($post_arr, TRUE);
        return $post_arr;
    }

    public function my_exec($cmd, $input = '')
    {
        $proc = proc_open($cmd, array(0 => array('pipe', 'r'), 1 => array('pipe', 'w'), 2 => array('pipe', 'w')), $pipes);
        fwrite($pipes[0], $input);
        fclose($pipes[0]);
        $stdout = stream_get_contents($pipes[1]);
        fclose($pipes[1]);
        $stderr = stream_get_contents($pipes[2]);
        fclose($pipes[2]);
        $rtn = proc_close($proc);
        return $rtn;
    }


    public function init_metadata_node()
    {
        $this->load->model('Login_model');
        //查user_id
        $user_sql = "select id from kunlun_user where name=?";
        $res_user = $this->Login_model->getList($user_sql,array('super_dba'));

        if (!empty($res_user)) {
            $user_id = $res_user[0]['id'];
        } else {
            $data['code'] = 500;
            $data['message'] = '该用户不存在';
            print_r(json_encode($data));
        }
        //查当前元数据ips
        $this->load->model('Cluster_model');

        $sql_meta = "select id,hostaddr,port from meta_db_nodes ";

        $res_meta = $this->Cluster_model->getList($sql_meta);

        $ips = '';
        foreach ($res_meta as $row => $value) {
            $ip = '';
            $port = '';
            foreach ($value as $key1 => $value1) {
                if ($key1 == 'hostaddr') {
                    $ip = $value1;
                }
                if ($key1 == 'port') {
                    $port = $value1;
                }
            }
            $ips .= $ip . ':' . $port . ',';
        }
        $rcr_meta = substr($ips, 0, strlen($ips) - 1);
        //如不存在创建表

        //先查是否存在此条数据，存在更新 不存在insert
        $select_sql = "select * from cluster_meta_info where name=?  and rcr_meta=?";

        $params = array('system', $rcr_meta);
        $res_select = $this->Login_model->getList($select_sql, $params);
        if (!$res_select) {
            $insert_sql = "insert into cluster_meta_info(user_id,name,rcr_meta) values ('$user_id','system','$rcr_meta'); ";
            $this->Login_model->updateList($insert_sql);
        }
    }
}
