<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once 'vendor/autoload.php';
use Symfony\Component\Yaml\Yaml;

class Server extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->config->load('myconfig');
		$this->post_url = $this->config->item('post_url');
		$this->user_name = $this->config->item('user_name');
		$this->version = $this->config->item('version');
		$this->db = $this->load->database('default', true);
		//$this->roledb = $this->load->database('role', true);
	}

	public function serverList()
	{

		//cluster_mgr当前主
		//改成到meta.json文件中取值
		$string = file_get_contents('./json/meta.json');
		$string = json_decode($string, true);
		$meta_count = count($string['nodes']);
		//遍历所有ip，分别连上去看是否找到cluster_mgr的主
		$res = '';
		$ip = '';
		$port = '';
		foreach ($string['nodes'] as $knode => $vnode) {
			if (empty($vnode['ip']) || empty($vnode['port'])) {
				$data['code'] = 500;
				$data['message'] = 'ip端口不能为空，请先进行boostrap安装元数据集群';
				print_r(json_encode($data));
				return;
			} else {
				$res_meta = $this->getMeta($vnode['ip'], $vnode['port']);
				if ($res_meta['code'] == 200) {
					$ip = $vnode['ip'];
					$port = $vnode['port'];
					$res = $res_meta;
					break;
				} else if ($meta_count == ($knode + 1)) {
					$data['code'] = 500;
					$data['message'] = $res_meta[0];
					print_r(json_encode($data));
					return;
				} else {
					continue;
				}
			}
		}
		if ($res['code'] == 200) {
			if (!empty($res[0]) && !empty($res[1])) {
				$post_url = 'http://' . $res[0] . ':' . $res[1] . '/HttpService/Emit';
				$old_post_url = $this->post_url;
				//修改配置文件myconfig.php
				if ($post_url !== $old_post_url) {
					rewrite_config([
						'post_url' => $post_url,
					]);
				}
				//先查元数据是mgr还是rbr
				$dbha_mode = '';
				$sql_dbha = "select value from kunlun_metadata_db.global_configuration";
				$res_dbha = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_dbha);
				if ($res_dbha['code'] == 200) {
					$dbha_mode = $res_dbha[0];
				} else {
					//连不上报错
					$data['code'] = 500;
					$data['message'] = $res_dbha[0];
					print_r(json_encode($data));
					return;
				}
				if ($dbha_mode == 'rbr') {
					//元数据当前的主
					$user_name = $this->user_name;
					$version = $this->version;
					$microtime = microtime(true);
					$timestamp = substr($microtime, 0, 13);
					$post_string = array('user_name' => $user_name, 'version' => $version, 'job_id' => '', 'timestamp' => $timestamp, 'job_type' => 'get_meta_master');
					$post_arr = $this->getMetaMaster($post_string, $post_url);
					//print_r($post_arr);
					if ($post_arr['error_code'] == 0) {
						if (!empty($post_arr['attachment']['master_host'])) {
							$res_main = [];
							$res_main['code'] = 200;
							$meta_ips = explode(':', $post_arr['attachment']['master_host']);
							$res_main[0] = $meta_ips[0];
							$res_main[1] = $meta_ips[1];
						} else {
							$data['code'] = $post_arr['error_code'];
							$data['message'] = $post_arr['error_info'];
							print_r(json_encode($data));
						}
					}
				} else if ($dbha_mode == 'mgr') {
					//获取元数据的主节点
					$sql_main = "select MEMBER_HOST,MEMBER_PORT from performance_schema.replication_group_members where MEMBER_ROLE = 'PRIMARY' and MEMBER_STATE = 'ONLINE'";
					$this->load->model('Change_model');
					$res_main = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_main);
				} else if ($dbha_mode == 'no_rep') {
					//获取元数据的主节点
					$sql_main = "select hostaddr,port from kunlun_metadata_db.meta_db_nodes where member_state='source'";
					$this->load->model('Change_model');
					$res_main = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_main);
				}
				if ($res_main['code'] == 200) {

					$yamlFilePath = 'config.yaml';
					$yamlContent = file_get_contents($yamlFilePath);
					$data = Yaml::parse($yamlContent);
					// 修改 YAML 数据
					$data['db-list'][0]['path'] = $res_main[0];
					$data['db-list'][0]['port'] = $res_main[1];
					$data['db-list'][1]['path'] = $res_main[0];
					$data['db-list'][1]['port'] = $res_main[1];
					$modifiedYamlContent = Yaml::dump($data, 2, 4);
					file_put_contents($yamlFilePath, $modifiedYamlContent);

					$db_ip = $this->db->hostname;
					$db_post = $this->db->port;
					if ($res_main[0] !== $db_ip || (int)$res_main[1] !== $db_post) {
						/*$this->db->hostname = "'" . $res_main[0] . "'";
						$this->db->port = $res_main[1];
						$this->roledb->hostname = "'" . $res_main[0] . "'";
						$this->roledb->port = $res_main[1];*/
						$f = fopen('./application/config/database.php', 'w+');
						$file = "<?php
		defined('BASEPATH') OR exit('No direct script access allowed');
		\$active_group = 'default';
		\$query_builder = TRUE;
		\$db_debug=FALSE;
		\$db['role']=array(
			'dsn'	=> '',
			'hostname' => '$res_main[0]',
			'port' => $res_main[1],
			'username' => 'pgx',
			'password' => 'pgx_pwd',
			'database' => 'kunlun_dba_tools_db',
			'dbdriver' => 'mysqli',
			'dbprefix' => '',
			'pconnect' => FALSE,
			'db_debug' => FALSE,
			'cache_on' => FALSE,
			'cachedir' => '',
			'char_set' => 'utf8',
			'dbcollat' => 'utf8_general_ci',
			'swap_pre' => '',
			'encrypt' => FALSE,
			'compress' => FALSE,
			'stricton' => FALSE,
			'failover' => array(),
			'options' => array(PDO::ATTR_TIMEOUT => 5),
			'save_queries' => TRUE,
		);
		\$db['default']=array(
			'dsn'	=> '',
			'hostname' => '$res_main[0]',
			'port' => $res_main[1],
			'username' => 'pgx',
			'password' => 'pgx_pwd',
			'database' => 'kunlun_metadata_db',
			'dbdriver' => 'mysqli',
			'dbprefix' => '',
			'pconnect' => FALSE,
			'db_debug' => FALSE,
			'cache_on' => FALSE,
			'cachedir' => '',
			'char_set' => 'utf8',
			'dbcollat' => 'utf8_general_ci',
			'swap_pre' => '',
			'encrypt' => FALSE,
			'compress' => FALSE,
			'stricton' => FALSE,
			'failover' => array(),
			'options' => array(PDO::ATTR_TIMEOUT => 5),
			'save_queries' => TRUE,
		);";
						fwrite($f, $file);
						fgets($f);
						echo "success\n";

					} else {
						echo "successful\n";
					}
				}
			}
		}
	}

	public function getMeta($ip, $port)
	{
		$this->load->model('Change_model');
		//先查主是否通,不通才遍历
		$sql_master = "select hostaddr,port from cluster_mgr_nodes where member_state='source'";
		$res_master = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_master);
		if ($res_master['code'] == 200) {
			$cluster_mgr_result = $this->getClusterMgrMaster($res_master[0], $res_master[1]);
			if ($cluster_mgr_result === true) {
				$data[0] = $res_master[0];
				$data[1] = $res_master[1];
				$data['code'] = 200;
			} else {
				$sql = "select hostaddr,port from cluster_mgr_nodes where hostaddr!='$res_master[0]' or port!='$res_master[1]'";
				$res = $this->Change_model->getAllMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql, '');
				//遍历cluster_mgr找http可连通端口
				if ($res['code'] == 200) {
					if (!empty($res['list'])) {
						$res_count = count($res['list']);
						foreach ($res['list'] as $k => $v) {
							$cluster_mgr_result = $this->getClusterMgrMaster($v['host'], $v['port']);
							if ($cluster_mgr_result === true) {
								$data[0] = $v['host'];
								$data[1] = $v['port'];
								$data['code'] = 200;
								break;
							} else if ($res_count == ($k + 1)) {
								$data['code'] = 500;
								$data[0] = '网络不通，请检查cluster_mgr的端口';
							} else {
								continue;
							}
						}
					} else {
						$data['code'] = 500;
						$data[0] = '网络不通，请检查cluster_mgr的端口' . $res_master[0] . '(' . $res_master[1] . ')';
					}
				} else {
					$data['code'] = $res['code'];
					$data[0] = $res[0] . $ip . '(' . $port . ')';
				}
			}
		} else {
			$data['code'] = $res_master['code'];
			$data[0] = $res_master[0] . $ip . '(' . $port . ')';
		}
		return $data;
	}

	public function getClusterMgrMaster($ip, $port)
	{
		$url = 'http://' . $ip . ':' . $port . '/HttpService/Emit';
		$httpcode = 0;
		$ch = curl_init();
		$timeout = 1; // 设置超时的时间[单位：秒]
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HEADER, 1);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_exec($ch);
		# 获取状态码赋值
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close($ch);
		if ($httpcode == 200) {
			return true;
		} else {
			return false;
		}
	}

	public function getMetaMaster($post_string, $post_url)
	{
		$this->load->model('Change_model');
		$post_data = str_replace("\\/", "/", json_encode($post_string));
		$post_arr = $this->Change_model->postData($post_data, $post_url);
		$post_arr = json_decode($post_arr, TRUE);
		return $post_arr;
	}
}
