<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ClusterSetting extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->config->load('myconfig');
        $this->key = $this->config->item('key');
        $this->post_url = $this->config->item('post_url');
    }

    public function getDBName($ip, $port, $user_name)
    {
        $this->load->model('Cluster_model');
        $sql_main = "select datname from pg_database where datname not in('template0','template1');";
        $res = $this->Cluster_model->DB($sql_main, $ip, $port, $user_name);
        return $res;
    }

    private function loadMeta(): array
    {
        $string = file_get_contents('./json/meta.json');
        return json_decode($string, true);
    }


    /**
     * 获取PG的表列表
     * @throws
     * @author wangwentao
     */
    public function getPGTableList()
    {
        $clusterId = $this->input->get('cluster_id');
        $all = $this->input->get('all');

        $username = $this->input->get('username');

        $result = [];
        $sql = "select port,hostaddr,user_name from comp_nodes where db_cluster_id='$clusterId' and status='active' ";
        $this->load->model('Cluster_model');
        $res = $this->Cluster_model->getList($sql);
        $res_count = count($res);
        if (!empty($res)) {
            foreach ($res as $knode => $vnode) {
                //连接该计算节点取库名
                $host = $this->Cluster_model->ipTranslation($vnode['hostaddr']);
                $res_main = $this->getDBName($host, $vnode['port'], $vnode['user_name']);
                if ($res_main['code'] == 500) {
                    if ($res_count == ($knode + 1)) {
                        $data['code'] = 201;
                        $data['message'] = '计算节点连接异常';
                        print_r(json_encode($data));
                        return;
                    } else {
                        continue;
                    }
                } else {
                    $ip = $vnode['hostaddr'];
                    $port = $vnode['port'];
                    $name = $vnode['user_name'];
                    foreach ($res_main as $knode => $item) {
                        $tmp = [];
                        $tmp["ip"] = $ip;
                        $tmp["port"] = $port;
                        $tmp["user"] = $name;
                        $tmp["value"] = $item->datname;
                        $tmp["desc"] = $item->datname;
                        $tmp["label"] = $item->datname;
                        $this->load->model('Cluster_model');
                        $schema = "select oid,* from pg_catalog.pg_namespace where nspname not in('pg_toast','pg_temp_1','pg_catalog','information_schema','pg_toast_temp_1');";
                        $scheam = $this->Cluster_model->getResult($schema, $host, $port, $name, $item->datname);
                        if ($scheam["code"] == 200) {
                            $tmp["children"] = [];
                            foreach ($scheam["arr"] as $v => $s) {
                                $_schema = [];
                                $_schema["label"] = $s["nspname"];
                                $_schema["value"] = $s["nspname"];
                                $_schema["desc"] = $s["nspname"];
                                $_schema["children"] = [];
                                //$sql_main = "select relname,n.nspname,relshardid From pg_class,pg_namespace n where relnamespace = n.oid and nspname = '" . $s['nspname'] . "';";
                                $sql_main = "SELECT A.relname AS relname FROM  ( SELECT relname, relfilenode FROM pg_class WHERE (relkind = 'r' or relkind = 'p') AND relnamespace = ( SELECT oid FROM pg_namespace WHERE nspname = '" . $s['nspname'] . "' ) )  A LEFT JOIN pg_description pgde ON pgde.objoid = A.relfilenode AND pgde.objsubid = 0";
                                $res = $this->Cluster_model->getResult($sql_main, $host, $port, $name, $item->datname);
                                if ($res["code"] == 200) {
                                    foreach ($res["arr"] as $v => $val) {
                                        $_table = [];
                                        $_table["label"] = $val["relname"];
                                        $_table["value"] = $val["relname"];
                                        $_table["desc"] = $val["relname"];
                                        $_schema["children"][] = $_table;
                                        //print_r($_schema);
                                    }
                                }
                                $tmp["children"][] = $_schema;
                            }
                        }
                        $result[] = $tmp;
                    }
                    break;
                }
            }
        } else {
            $data['code'] = 201;
            $data['message'] = '该集群无可用的计算节点';
            print_r(json_encode($data));
            return;
        }

        if ($username != "") {
            $resp = [];
            $saas = $this->loadMeta();
            if (isset($saas['saas']) && $saas['saas'] > 0) {
                $this->load->model('Cluster_model');
                $sql = "select * from kunlun_dba_tools_db.kunlun_user where name = '{$username}'";
                $res = $this->Cluster_model->getList($sql);
                if (count($res) > 0) {
                    $res = $res[0];
                    foreach ($result as $k => $v) {
                        if (strstr($v['value'], $res['db_name'])) {
                            $resp[] = $v;
                        }
                    }
                }
                echo json_encode([
                    'code' => 200,
                    'list' => $resp,
                ]);
                exit();
            }
        }
        echo json_encode([
            'code' => 200,
            'list' => $result,
        ]);
        exit();
        $sql = "select id,name from db_clusters where memo!='' and memo is not null and status!='deleted' and id = '{$clusterId}'";
        $this->load->model('Cluster_model');
        $res = $this->Cluster_model->getList($sql);


        if ($res === false) {
            throw new ApiException('所选集群不存在');
        }
        $nodeSql = "select hostaddr,port,user_name,passwd from comp_nodes where db_cluster_id = {$clusterId} and status <> 'deleted' order by id asc limit 1";
        $res = $this->Cluster_model->getList($nodeSql);
        if ($res === false) {
            throw new ApiException('未查询到PG节点');
        }
        $node = current($res);

        //print_r($node);

        $con = get_pg_con($node['hostaddr'], $node['port'], $node['user_name'], $node['passwd'], 'postgres');
        // 获取所有分区表
        $zoneTables = pg_find($con, "SELECT oid, relname from pg_class where relkind = 'p'");
        if (!$zoneTables) {
            $zoneTables = [];
        }

        // 遍历查询所有表信息
        $zoneTables = implode("','", array_column($zoneTables, 'relname'));
        if (!$zoneTables && $all !== '1') {
            $zoneTables = 1;
        }
        $sql = "select schemaname as schema,tablename as table,tableowner as db from pg_tables";
        if ($zoneTables) {
            $zoneTables = "'" . $zoneTables . "'";
            $sql .= " where tablename in ({$zoneTables})";
        }

        $tables = pg_find($con, $sql);

        //print_r($tables);
        //exit();
        $tableNodes = [];
        foreach ($tables as $table) {
            $tableNodes[$table['db']][$table['schema']][$table['table']] = $table['table'];
        }
        $data = [];
        foreach ($tableNodes as $key => $tableNode) {
            $list = [
                'value' => $key,
                'label' => $key,
                'desc' => 'db',
            ];
            $children = [];
            foreach ($tableNode as $sk => $schema) {
                $schemaList = [
                    'value' => $sk,
                    'label' => $sk,
                    'desc' => 'schema',
                ];
                $schemaChildren = [];
                foreach ($schema as $tKey => $tableName) {
                    $schemaChildren[] = [
                        'value' => $tKey,
                        'label' => $tKey,
                        'desc' => 'table',
                    ];
                }
                $schemaList['children'] = $schemaChildren;
                $children[] = $schemaList;
            }
            $list['children'] = $children;
            $data[] = $list;
        }
        echo json_encode([
            'code' => 200,
            'list' => $data,
        ]);
    }

    public function getDataCenters()
    {
        $username = $this->input->get('name');
        $city = $this->input->get('city');
        $province = $this->input->get('province');
        $city = urldecode($city);
        $province = urldecode($province);
        $type = $this->input->get('type');
        $this->load->model('Cluster_model');

        $sql = "select a.id,a.name,a.owner,a.province,a.city from data_centers a left join server_nodes s on a.id=s.dc_id where s.hostaddr is not null ";
        if (!empty($province)) {
            $sql .= " and a.province = '$province'";
        }
        if (!empty($city)) {
            $sql .= " and  a.city = '$city'";
        }
        $sql .= "group by s.dc_id";
        //echo $sql;exit;
        $res = $this->Cluster_model->getList($sql);
        if ($res === false) {
            $res = [];
        }
        $relation = [];
        foreach ($res as $key => $value) {
            $res[$key]['node_num'] = 1;
            $res[$key]['master'] = false;
            $res[$key]['id'] = $value['name'];
            if ($type == 'storage') {
                $ips = $this->getStorIDCIps($value['id']);
            } elseif ($type == 'comps') {
                $ips = $this->getCompIDCIps($value['id']);
            }
            $res[$key]['iplist'] = $ips;
        }
        echo json_encode([
            'code' => 200,
            'list' => [
                'res' => $res,
                'r' => $relation,
            ],
            'message' => 'success',
        ]);
    }

    /**
     * 集群下拉选项
     * @author wangwentao
     */
    public function clusterOptions()
    {
        $username = $this->input->get('name');
        $filterId = $this->input->get('filter_id');
        $cluster_id = $this->input->get('cluster_id');
        $sql = "select id,name from db_clusters where memo!='' and memo is not null and status!='deleted' and id!='$cluster_id'";
        if (!empty($username)) {
            $sql .= " and nick_name like '%$username%'";
        }
        if ($filterId) {
            $sql .= " and id <> '{$filterId}'";
        }
        $sql .= ' order by id desc';
        $this->load->model('Cluster_model');
        $res = $this->Cluster_model->getList($sql);
        if ($res === false) {
            $res = [];
        }
        echo json_encode([
            'code' => 200,
            'list' => $res,
            'message' => 'success',
        ]);
    }

    /**
     * 表重分布
     * @author wangwentao
     */
    public function tableRepartition()
    {
        //获取token
        $arr = apache_request_headers(); //获取请求头数组
        $token = $arr["Token"];
        if (empty($token)) {
            throw new ApiException('token不能为空', 201);
        }
        //判断参数
        $string = json_decode(@file_get_contents('php://input'), true);
        //调接口
        $this->load->model('Cluster_model');
        $post_data = str_replace("\\/", "/", json_encode($string));
        $post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
        $data = json_decode($post_arr, true);
        $data['code'] = 200;
        if ($data['error_code'] !== '0') {
            $data['code'] = 500;
            $data['message'] = isset($data['error_info']) ? $data['error_info'] : '系统错误';
        }
        echo json_encode($data);
    }


    public function getRecordLogicalBackup()
    {
        $cluster_id = $this->input->get('cluster_id');
        $type = $this->input->get('type');
        $restore_type = '"backup_type":"' . $type . '"';
        if ($cluster_id == "") {
            throw new ApiException('集群ID 不能为空', 201);
        }
        $sql = "SELECT cluster_id,db_table,min(backup_time) as backup_time FROM cluster_logicalbackup_record
	WHERE backup_state='done' AND cluster_id='$cluster_id' and db_table like '%_$$%' GROUP BY db_table ";
        //echo $sql;exit;
        $this->load->model('Cluster_model');
        $res = $this->Cluster_model->getList($sql);
        if ($res === false) {
            $res = [];
        }

        $table = [];
        $db = [];
        $schema = [];
        $if_db = false;
        $if_schema = false;
        $if_table = false;
        foreach ($res as $key => $item) {
            $db_arr = explode("_$\$_", $item['db_table']);
            $schema_arr = explode(".", $db_arr[1]);
            if ($type == 'db') {
                if (!empty($db)) {
                    foreach ($db as $d) {
                        if ($d['label'] === $db_arr[0]) {
                            $if_db = false;
                            break;
                        } else {
                            $if_db = true;
                        }
                    }
                } else {
                    $if_db = true;
                }
                if ($if_db == true) {
                    $db[] = [
                        "label" => $db_arr[0],
                        "value" => $db_arr[0],
                        "desc" => $db_arr[0],
                        "children" => null,
                        "time" => $item['backup_time'],
                        "backup_time" => $item['backup_time'],
                    ];
                }
            }
            if ($type == 'schema') {
                $schema_table = explode(".", $item['db_table']);
                if (!empty($schema)) {
                    foreach ($schema as $row) {
                        if ($row['label'] === $schema_table[0]) {
                            $if_schema = false;
                            break;
                        } else {
                            $if_schema = true;
                        }
                    }
                } else {
                    $if_schema = true;
                }
                if ($if_schema == true) {
                    $schema[] = [
                        "label" => $schema_table[0],
                        "value" => $schema_table[0],
                        "desc" => $schema_table[0],
                        "time" => $item['backup_time'],
                        "backup_time" => $item['backup_time'],
                    ];
                }
            }
            if ($type == 'table') {
                if (!empty($table)) {
                    foreach ($table as $t) {
                        if ($t['label'] === $item['db_table']) {
                            $if_table = false;
                            break;
                        } else {
                            $if_table = true;
                        }
                    }
                } else {
                    $if_table = true;
                }
                if ($if_table == true) {
                    $table[] = [
                        "label" => $item['db_table'],
                        "value" => $item['db_table'],
                        "desc" => $item['db_table'],
                        "children" => null,
                        "time" => $item['backup_time'],
                        "backup_time" => $item['backup_time'],
                    ];
                }
            }
        }
//		//格式化$schema
//		if(!empty($schema)){
//			$schema_db=[];
//			$if_schema_c=false;
//			foreach ($schema as $s=>$r){
//				$d_s=explode('_$$_',$r['value']);
//				if(!empty($schema_db)){
//					foreach ($schema_db as $t=>$v) {
//						if ($v['label'] === $d_s[0]) {
//							$if_schema_c=false;
//							$arr = array('label' => $d_s[1], 'value' => $r['value'], 'desc' => $r['desc'], 'time' => $r['time'], 'backup_time' => $r['backup_time'],);
//							array_push($schema_db[$t]['children'], $arr);
//							break;
//						}else{
//							$if_schema_c=true;
//						}
//					}
//				}else{
//					$if_schema_c=true;
//				}
//				if($if_schema_c==true){
//					$schema_db[] = [
//						'label'=>$d_s[0],
//						'value'=>$d_s[0],
//						'children'=>[]
//					];
//					$child=array('label' => $d_s[1],'value' => $r['value'],'desc' => $r['desc'],'time' => $r['time'],'backup_time' => $r['backup_time']);
//					array_push($schema_db[$s]['children'], $child);
//
//				}
//
//			}
//		}

        echo json_encode([
            'code' => 200,
            'list' => [
                'table' => $table,
                'db' => $db,
                'schema' => $schema
            ],
            'message' => 'success',
        ]);

    }

    public function getStorIDCIps($id)
    {
        $this->load->model('Cluster_model');
        $sql = "select hostaddr from server_nodes where dc_id='$id' and machine_type='storage' and node_stats='running'  group by hostaddr";
        $res = $this->Cluster_model->getList($sql);
        if ($res === false) {
            $res = '';
        }
        return $res;
    }

    public function getCompIDCIps($id)
    {
        $this->load->model('Cluster_model');
        $sql = "select hostaddr from server_nodes where dc_id='$id' and machine_type='computer' and node_stats='running' group by hostaddr";
        $res = $this->Cluster_model->getList($sql);
        if ($res === false) {
            $res = '';
        }
        return $res;
    }

    public function repeat()
    {
        $clusterId = $this->input->get('cluster_id');
        $type = $this->input->get('type');
        $table = $this->input->get('table');
        $sql = "select port,hostaddr,user_name from comp_nodes where db_cluster_id='$clusterId' and status='active' limit 1";
        $this->load->model('Cluster_model');
        $res = $this->Cluster_model->getList($sql);
        if (!empty($res)) {
            $port = $res[0]['port'];
            $name = $res[0]['user_name'];
            $host = $this->Cluster_model->ipTranslation($res[0]['hostaddr']);
            if ($type == 'db') {
                //连接该计算节点取库名
                $res_main = $this->getDBName($host, $res[0]['port'], $res[0]['user_name']);
                if ($res_main['code'] == 500) {
                    $data['code'] = 500;
                    print_r(json_encode($data));
                    return;
                } else {
                    foreach ($res_main as $kn => $item) {
                        if ($table[0] == $item->datname) {
                            $data['code'] = 501;
                            print_r(json_encode($data));
                            return;
                        }
                    }
                }
            }
            if ($type == 'schema') {
                $arr = explode('_$$_', $table[0]);
                $datebase = $arr[0];
                $schema = $arr[1];
                $schema_sql = "select schema_name from information_schema.schemata where schema_name not in('pg_toast','pg_temp_1','pg_catalog','information_schema','pg_toast_temp_1');";
                $scheam_res = $this->Cluster_model->getResult($schema_sql, $host, $port, $name, $datebase);
                if (!empty($scheam_res)) {
                    foreach ($scheam_res['arr'] as $k => $v) {
                        if ($schema == $v['schema_name']) {
                            $data['code'] = 501;
                            print_r(json_encode($data));
                            return;
                        }
                    }
                }
            }
            if ($type == 'table') {
                $arr = explode('_$$_', $table[0]);
                $datebase = $arr[0];
                $schema_arr = explode('.', $arr[1]);
                $schema = $schema_arr[0];
                $table_arr = $schema_arr[1];
                $table_sql = "SELECT A.relname AS relname FROM  ( SELECT relname, relfilenode FROM pg_class WHERE (relkind = 'r' or relkind = 'p') AND relnamespace = ( SELECT oid FROM pg_namespace WHERE nspname = '$schema' ) )  A LEFT JOIN pg_description pgde ON pgde.objoid = A.relfilenode AND pgde.objsubid = 0";
                $table_res = $this->Cluster_model->getResult($table_sql, $host, $port, $name, $datebase);
                if (!empty($table_res)) {
                    foreach ($table_res['arr'] as $k1 => $v1) {
                        if ($table_arr == $v1['relname']) {
                            $data['code'] = 501;
                            print_r(json_encode($data));
                            return;
                        }
                    }
                }
            }
        } else {
            $data['code'] = 201;
            print_r(json_encode($data));
        }
    }
}