<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MonitoringOperations extends CI_Controller {
    private $Cluster_model;
    private $Login_model;

    public function __construct() {
        parent::__construct();
        $this->load->model('Cluster_model');
        $this->load->model('Login_model');
    }

    public function getActiveShards() {
        $sql = "SELECT db_cluster_id, shard_id 
                FROM shard_nodes 
                WHERE status != 'deleted' 
                GROUP BY db_cluster_id, shard_id";
        return $this->Cluster_model->getList($sql) ?: [];
    }

    private function processNodeAlarms($shard, $cluster_name, &$alarms) {
        $errors = $this->compNodeError($shard['db_cluster_id'], $cluster_name);
        if (!empty($errors)) {
            foreach ($errors as $error) {
                if ($this->isNewAlarm('comp_node_exception', $error)) {
                    $alarms[] = [
                        'type' => 'comp_node_exception',
                        'content' => $error,
                        'cluster_id' => $shard['db_cluster_id']
                    ];
                }
            }
        }
    }

    private function processShardAlarms($shard, $user_name, $shard_name, $cluster_name, &$alarms) {
        $errors = $this->shardError(
            $shard['db_cluster_id'],
            $shard['shard_id'],
            $user_name,
            $shard_name,
            $cluster_name
        );
        if (!empty($errors)) {
            foreach ($errors as $error) {
                if ($this->isNewAlarm('shard_exception', $error)) {
                    $alarms[] = [
                        'type' => 'shard_exception',
                        'content' => $error,
                        'cluster_id' => $shard['db_cluster_id'],
                        'shard_id' => $shard['shard_id']
                    ];
                }
            }
        }
    }

    private function processMachineAlarms(&$alarms) {
        $errors = $this->machineError();
        if (!empty($errors)) {
            foreach ($errors as $error) {
                if ($this->isNewAlarm('machine_exception', $error)) {
                    $alarms[] = [
                        'type' => 'machine_exception',
                        'content' => $error
                    ];
                }
            }
        }
    }

    private function processManualSwitchAlarms(&$alarms) {
        $errors = $this->manualSwitchError();
        if (!empty($errors)) {
            foreach ($errors as $error) {
                if ($this->isNewAlarm('manual_switch_exception', $error['message'])) {
                    $alarms[] = [
                        'type' => 'manual_switch_exception',
                        'content' => $error['message'],
                        'cluster_id' => $error['cluster_id'] ?? null,
                        'shard_id' => $error['shard_id'] ?? null
                    ];
                }
            }
        }
    }

    private function processBackupAlarms(&$alarms) {
        $errors = $this->backupError();
        if (!empty($errors)) {
            foreach ($errors as $error) {
                if ($this->isNewAlarm('backup_exception', $error['message'])) {
                    $alarms[] = [
                        'type' => 'backup_exception',
                        'content' => $error['message'],
                        'cluster_id' => $error['cluster_id'] ?? null
                    ];
                }
            }
        }
    }

    private function processClusterJobAlarms(&$alarms) {
        $errors = $this->clusterJobError();
        if (!empty($errors)) {
            foreach ($errors as $error) {
                if ($this->isNewAlarm('cluster_job_exception', $error['message'])) {
                    $alarms[] = [
                        'type' => 'cluster_job_exception',
                        'content' => $error['message'],
                        'cluster_id' => $error['cluster_id'] ?? null,
                        'job_id' => $error['job_id'] ?? null
                    ];
                }
            }
        }
    }

    private function processRCRAlarms($user_name, &$alarms) {
        $errors = $this->rcrError($user_name);
        if (!empty($errors)) {
            foreach ($errors as $error) {
                if ($this->isNewAlarm('rcr_exception', $error['message'])) {
                    $alarms[] = [
                        'type' => 'rcr_exception',
                        'content' => $error['message'],
                        'cluster_id' => $error['cluster_id'] ?? null
                    ];
                }
            }
        }
    }

    private function compNodeError($cluster_id, $cluster_name) {
        $sql = "select id,hostaddr,port from comp_nodes where db_cluster_id='$cluster_id' and status='inactive'";
        $res = $this->Cluster_model->getList($sql);
        $error = array();
        if (!empty($res)) {
            foreach ($res as $row) {
                $error[] = $cluster_name . '(' . $cluster_id . '),' . $row['hostaddr'] . '(' . $row['port'] . ')' . 'Compute Node Exception';
            }
        }
        return $error;
    }

    private function isNewAlarm($type, $content) {
        $sql = "SELECT id FROM cluster_alarm_info \
                WHERE alarm_type = ? \
                AND job_info = ? \
                AND status = 'unhandled'\
                LIMIT 1";
        return !$this->Cluster_model->getList($sql, [$type, $content]);
    }

    private function shardError($cluster_id, $id, $user_id, $shard_name, $cluster_name) {
        //查是否存在最大延迟值
        $this->load->model('Login_model');
        //如不存在创建表

        $select_sql = "select max_delay_time from shard_max_dalay where shard_id='$id' and db_cluster_id='$cluster_id' and user_id='$user_id'";
        $res_select = $this->Cluster_model->getList($select_sql);
        if (!empty($res_select)) {
            $maxtime = $res_select[0]['max_delay_time'];
        } else {
            $maxtime = '100';
        }
        $this->load->model('Cluster_model');
        $sql = "select hostaddr,port,replica_delay from shard_nodes where shard_id='$id' and db_cluster_id='$cluster_id' and replica_delay>'$maxtime' and status!='deleted'";
        $res = $this->Cluster_model->getList($sql);
        $error = array();
        if (!empty($res)) {
            foreach ($res as $row) {
                array_push($error, $cluster_name . '(' . $cluster_id . '),' . $shard_name . ',' . $row['hostaddr'] . '(' . $row['port'] . ')' . 'The current delay is' . $row['replica_delay'] . 's,Exceed delay maximum' . $maxtime . 's');
            }
        }
        //存储节点异常
        $sql_storage = "select hostaddr,port from shard_nodes where shard_id='$id' and db_cluster_id='$cluster_id' and status='inactive'";
        $res_storage = $this->Cluster_model->getList($sql_storage);
        if (!empty($res_storage)) {
            foreach ($res_storage as $row_stor) {
                array_push($error, $cluster_name . '(' . $cluster_id . '),' . $shard_name . ',' . $row_stor['hostaddr'] . '(' . $row_stor['port'] . ')' . 'Storage Node Exception');
            }
        }
        return $error;
    }

    private function machineError() {
        $this->load->model('Cluster_model');
        $sql = "select hostaddr from server_nodes where node_stats='dead' GROUP BY hostaddr ";
        $res = $this->Cluster_model->getList($sql);
        $error = array();
        if (!empty($res)) {
            foreach ($res as $row) {
                $error[] = $row['hostaddr'] . ',The device is offline';
            }
        }
        return $error;
    }

    private function manualSwitchError() {
        $this->load->model('Cluster_model');
        $sql = "select host,shard_id,cluster_id,taskid,err_msg as message,consfailover_msg from rbr_consfailover where err_code!=0 ";
        $res = $this->Cluster_model->getList($sql);
        foreach ($res as $row => $value) {
            foreach ($value as $key2 => $value2) {
                $string = preg_replace('/\r|\n/', '\n', trim($res[$row]['consfailover_msg']));
                $string = json_decode($string, true);
                if (!empty($string['sw_type'])) {
                    $res[$row]['sw_type'] = $string['sw_type'];
                } else {
                    $res[$row]['sw_type'] = '';
                }
            }
            unset($res[$row]['consfailover_msg']);
        }
        return $res;
    }

    private function backupError() {
        $this->load->model('Cluster_model');
        $sql = "select id,job_type,memo,when_started,when_ended,job_info,user_name from cluster_general_job_log where status='failed' and job_type='shard_coldbackup'; ";
        $res = $this->Cluster_model->getList($sql);
        foreach ($res as $row => $value) {
            foreach ($value as $key2 => $value2) {
                $string = preg_replace('/\r|\n/', '\n', trim($res[$row]['memo']));
                $string = json_decode($string, true);
                if (!empty($string['error_info'])) {
                    $res[$row]['message'] = $string['error_info'];
                } else {
                    $res[$row]['message'] = '';
                }
                $job_info = preg_replace('/\r|\n/', '\n', trim($res[$row]['job_info']));
                $job_info = json_decode($job_info, true);
                if (!empty($job_info)) {
                    //取出ip，port去查shard_node和comp_nodes表是否存在
                    $if_exist = $this->getIpPort($job_info['paras']['ip'], $job_info['paras']['port']);
                    if ($if_exist) {
                        if ($if_exist[0]['type'] == 'compute') {
                            $res[$row]['ip'] = $job_info['paras']['ip'];
                            $res[$row]['port'] = $job_info['paras']['port'];
                            $res[$row]['compid'] = $if_exist[0]['id'];
                            $res[$row]['shardid'] = null;
                            $res[$row]['cluster_id'] = $if_exist[0]['db_cluster_id'];
                        } else {
                            $res[$row]['ip'] = $job_info['paras']['ip'];
                            $res[$row]['port'] = $job_info['paras']['port'];
                            $res[$row]['compid'] = null;
                            $res[$row]['shardid'] = $if_exist[0]['id'];
                            $res[$row]['cluster_id'] = $if_exist[0]['db_cluster_id'];
                        }
                    } else {
                        $res[$row]['ip'] = '';
                        $res[$row]['port'] = '';
                        $res[$row]['compid'] = '';
                        $res[$row]['shardid'] = '';
                        $res[$row]['cluster_id'] = '';
                    }
                }
            }
            unset($res[$row]['memo']);
            unset($res[$row]['job_info']);
        }
        return $res;
    }

    private function clusterJobError() {
        $this->load->model('Cluster_model');
        $sql = "select id,job_type,memo,when_started,when_ended,job_info,user_name from cluster_general_job_log where status='failed' and job_type in('create_cluster','delete_cluster','add_shards','delete_shard','add_comps','delete_comp','add_nodes','delete_node','manual_backup_cluster');";
        $res = $this->Cluster_model->getList($sql);
        foreach ($res as $row => $value) {
            foreach ($value as $key2 => $value2) {
                $string = preg_replace('/\r|\n/', '\n', trim($res[$row]['memo']));
                $string = json_decode($string, true);
                if (!empty($string['error_info'])) {
                    $res[$row]['message'] = $string['error_info'];
                } else {
                    $res[$row]['message'] = '';
                }
                $job_info = preg_replace('/\r|\n/', '\n', trim($res[$row]['job_info']));
                $job_info = json_decode($job_info, true);
                if (!empty($job_info['paras'])) {
                    $res[$row]['paras'] = $job_info['paras'];
                } else {
                    $res[$row]['paras'] = '';
                }
            }
            unset($res[$row]['memo']);
            unset($res[$row]['job_info']);
        }
        return $res;
    }

    private function rcrError($user_id): array {
        //rcr同步异常
        $this->load->model('Cluster_model');
        $sql = "select rcr_infos_id,dump_host from cluster_rcr_meta_sync where meta_sync_state ='disconnect' GROUP BY id ";
        $res = $this->Cluster_model->getList($sql);
        $error = array();
        if (!empty($res)) {
            foreach ($res as $row) {
                $error[] = 'Id of ' . $row['rcr_infos_id'] . 'RCR synchronous abnormal relationships [' . $row['dump_host'] . ']';
            }
        }
        //rcr延迟过大
        //先查表是否存在
        $this->load->model('Login_model');
        $sqldalay = "select TABLE_NAME from information_schema.TABLES where TABLE_NAME = 'rcr_max_dalay';";
        $resdalay = $this->Login_model->getList($sqldalay);
        if ($resdalay !== false) {
            $select_sql = "select id,rcr_id,max_delay_time from rcr_max_dalay where user_id='$user_id'";
            $res_select = $this->Login_model->getList($select_sql);
            if (!empty($res_select)) {
                foreach ($res_select as $row_select) {
                    $maxtime = $row_select['max_delay_time'];
                    $rcr_id = $row_select['rcr_id'];
                    $sql_rcr_delay = "select id,replica_delay from cluster_rcr_infos where status !='deleted' and id= '$rcr_id'";
                    $res_rcr_delay = $this->Cluster_model->getList($sql_rcr_delay);
                    if (!empty($res_rcr_delay)) {
                        if ($maxtime < $res_rcr_delay[0]['replica_delay']) {
                            $error[] = 'Witch id ' . $rcr_id . 'RCR relationship too much delay, the current delay time for ' . $res_rcr_delay[0]['replica_delay'] . '，最大延迟时间为' . $maxtime;
                        }
                    }
                }
            }
        }
        return $error;
    }

    private function getIpPort($ip, $port) {
        $sql = "select db_cluster_id,id from comp_nodes where hostaddr='$ip' and port='$port' and status!='deleted'";
        $res = $this->Cluster_model->getList($sql);
        if (!empty($res)) {
            foreach ($res as $row => $value) {
                $res[$row]['type'] = 'compute';
            }
            return $res;
        } else {
            $sql_shard = "select db_cluster_id,shard_id as id from shard_nodes where hostaddr='$ip' and port='$port' and status!='deleted'";
            $res_shard = $this->Cluster_model->getList($sql_shard);
            if (!empty($res_shard)) {
                foreach ($res_shard as $row1 => $value1) {
                    $res_shard[$row1]['type'] = 'storage';
                }
                return $res_shard;
            } else {
                return '';
            }
        }
    }
} 