<?php

class Change_model extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	}

	//mysql连接
	public function getMysql($host, $port, $username, $pwd, $dbname, $sql)
	{

		mysqli_report(MYSQLI_REPORT_STRICT);
		try {
			$conn = mysqli_connect("{$host}:{$port}", $username, $pwd, $dbname);
			$query = mysqli_query($conn, $sql);
			$arr = mysqli_fetch_row($query);
			$arr['code'] = 200;
			return $arr;
		} catch (Exception $e) {
			$arr[0] = iconv('gbk', 'utf-8', $e->getMessage());
			$arr['code'] = 500;
			return $arr;
		}
	}


    public function getMysqlRes($host, $port, $username, $pwd, $dbname, $sql)
    {
        mysqli_report(MYSQLI_REPORT_STRICT);
        try {
            $conn = mysqli_connect("{$host}:{$port}", $username, $pwd, $dbname);
            // 设置连接的字符集为utf8
            mysqli_set_charset($conn, 'utf8');
            $list = [];
            if ($result = mysqli_query($conn, $sql)) {
                // 一条条获取
                while ($row = mysqli_fetch_assoc($result)) {
                    $list[] = $row; // 每行数据已为键值对
                }
                // 释放结果集合
                mysqli_free_result($result);
            }
            $arr = [
                'code' => 200,
                'list' => $list
            ];
            mysqli_close($conn);
            return $arr;
        } catch (Exception $e) {
            $arr = [
                'code' => 500,
                'message' => iconv('gbk', 'utf-8', $e->getMessage())
            ];
            return $arr;
        }
    }

	//mysql连接
	public function getAllMysql($host, $port, $username, $pwd, $dbname, $sql,$string)
	{
		mysqli_report(MYSQLI_REPORT_STRICT);
		try {
			$conn = mysqli_connect("{$host}:{$port}", $username, $pwd, $dbname);
			$lists = array();
			$list = array();
			if ($result = mysqli_query($conn, $sql)) {
				// 一条条获取
				while ($row = mysqli_fetch_row($result)) {
					if($string=='cluster_info'){
						$list = array('cluster_id' => $row[0], 'name' => $row[1],'nick_name' => $row[2]);
					}else if($string=='shard_nodes_info'){
						$list = array('host' => $row[0], 'port' => $row[1],'status' => $row[2], 'replica_delay' => $row[3],'member_state'=> $row[4]);
					}else{
						$list = array('host' => $row[0], 'port' => $row[1]);
					}
					$lists[] = $list;
				}
				// 释放结果集合
				mysqli_free_result($result);
			}
			$arr['list'] = $lists;
			$arr['code'] = 200;
			return $arr;
		} catch (Exception $e) {
			$arr[0] = iconv('gbk', 'utf-8', $e->getMessage());
			$arr['code'] = 500;
			return $arr;
		}
	}

	public function postData($post_data, $url)
	{
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_TIMEOUT, 5);   //只需要设置30秒的数量就可以
		curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0); //强制协议为1.0

		curl_setopt($ch, CURLOPT_HTTPHEADER, ['Expect: ']); //头部要送出'Expect: '
		curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4); //强制使用IPV4协议解析域名
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'Content-Type: application/json',
			'Content-Length: ' . strlen($post_data),
		]);
		$result = curl_exec($ch);
		$curl_errno = curl_errno($ch);
		curl_close($ch);
		return $result;
	}

}

