package main

// 性能配置参数
var PerformanceConfig = struct {
	// 并发控制
	MaxConcurrentTasks int // 最大并发任务数

	// HTTP相关
	HttpMaxIdleConnsPerHost   int   // 每个主机的最大空闲连接数
	HttpMaxIdleConns          int   // 总的最大空闲连接数
	HttpIdleConnTimeout       int64 // 空闲连接超时时间(秒)
	HttpResponseHeaderTimeout int64 // 响应头超时时间(秒)
	HttpClientTimeout         int64 // HTTP客户端超时时间(秒)

	// ES相关
	ESDefaultBatchSize  int    // ES默认批处理大小
	ESDefaultScrollTime string // ES默认scroll时间

	// MongoDB相关
	MongoDefaultBatchSize int // MongoDB默认批处理大小

	// TDengine相关
	TDDefaultBatchSize int // TDengine默认批处理大小

	// Socket相关
	SocketBufferSize int // Socket缓冲区大小

	// PB级数据同步优化参数
	ChunkSize           int64 // 数据分块大小(MB)
	MaxMemoryUsage      int64 // 最大内存使用量(MB)
	ParallelStreams     int   // 并行数据流数量
	WriteBufferSize     int   // 写缓冲区大小(KB)
	ReadBufferSize      int   // 读缓冲区大小(KB)
	StreamCompression   bool  // 是否启用流压缩
	CompressionLevel    int   // 压缩级别(1-9)，1最快，9压缩率最高
	CheckpointInterval  int64 // 检查点间隔(秒)
	BatchCommitSize     int64 // 批量提交大小(MB)
	NetworkTimeout      int64 // 网络超时时间(秒)
	RetryAttempts       int   // 失败重试次数
	RetryBackoffSeconds int   // 重试退避时间(秒)
}{
	// 默认配置值
	MaxConcurrentTasks: 100,

	HttpMaxIdleConnsPerHost:   100,
	HttpMaxIdleConns:          200,
	HttpIdleConnTimeout:       90,
	HttpResponseHeaderTimeout: 10,
	HttpClientTimeout:         30,

	ESDefaultBatchSize:  5,
	ESDefaultScrollTime: "1m",

	MongoDefaultBatchSize: 1000,

	TDDefaultBatchSize: 1000,

	SocketBufferSize: 65536, // 64KB

	// PB级数据同步默认值
	ChunkSize:           256,  // 256MB数据块
	MaxMemoryUsage:      8192, // 8GB最大内存
	ParallelStreams:     8,    // 8个并行数据流
	WriteBufferSize:     8192, // 8MB写缓冲区
	ReadBufferSize:      8192, // 8MB读缓冲区
	StreamCompression:   true, // 启用压缩
	CompressionLevel:    6,    // 中等压缩级别
	CheckpointInterval:  300,  // 5分钟检查点
	BatchCommitSize:     1024, // 1GB批量提交
	NetworkTimeout:      3600, // 1小时网络超时
	RetryAttempts:       5,    // 5次重试
	RetryBackoffSeconds: 30,   // 30秒退避
}
