#!/bin/bash

# 执行调试版本编译
./debug_build.sh

# 推送到远程服务器
echo "推送到远程服务器..."
scp ./consistent_sql kunlun@192.168.0.20:/tmp
scp ./monitor_consistent_sql.sh kunlun@192.168.0.20:/tmp

# 远程设置
ssh kunlun@192.168.0.20 << 'EOF'
  # 在远程服务器创建日志目录
  mkdir -p /tmp/logs
  
  # 给监控脚本添加执行权限
  chmod +x /tmp/monitor_consistent_sql.sh
  
  echo "远程设置完成，可以通过以下方式运行:"
  echo "1. 直接运行: cd /tmp && ./consistent_sql -logDir=./logs"
  echo "2. 带监控运行: cd /tmp && ./monitor_consistent_sql.sh"
EOF

echo "推送成功"