#!/bin/bash
LOG_FILE="consistent_sql_monitor.log"
MAX_RESTART=10
RESTART_COUNT=0

echo "$(date): 监控脚本启动" >> $LOG_FILE

# 确保日志目录存在
mkdir -p logs

while true; do
    echo "$(date): 启动consistent_sql" >> $LOG_FILE
    
    # 使用工作目录和日志目录参数启动程序
    ./consistent_sql -logDir=./logs -workDir=$(pwd) &
    PID=$!
    
    # 每5分钟记录一次系统状态
    while kill -0 $PID 2>/dev/null; do
        sleep 300
        MEMORY=$(ps -o rss= -p $PID 2>/dev/null || echo "进程已终止")
        echo "$(date): consistent_sql (PID:$PID) 运行正常，内存使用: $MEMORY KB" >> $LOG_FILE
    done
    
    # 程序退出
    EXIT_CODE=$?
    echo "$(date): consistent_sql异常退出，退出码: $EXIT_CODE" >> $LOG_FILE
    
    # 检查系统日志是否有OOM记录
    if grep -q "Out of memory" /var/log/syslog 2>/dev/null; then
        echo "$(date): 检测到OOM killer记录，可能是内存不足导致程序终止" >> $LOG_FILE
    fi
    
    # 重启计数
    RESTART_COUNT=$((RESTART_COUNT+1))
    if [ $RESTART_COUNT -ge $MAX_RESTART ]; then
        echo "$(date): 达到最大重启次数 $MAX_RESTART，停止监控" >> $LOG_FILE
        exit 1
    fi
    
    # 等待短暂时间后重启
    sleep 5
done
