# MongoDB 配置检测功能测试指南

## 功能说明

我已经在程序中添加了 MongoDB 配置检测功能，每次启动 MongoDB 同步任务时会自动检查配置。

## 检测内容

### 1. MongoDB 版本检查
- 检查 MongoDB 版本是否支持 Change Stream（需要 3.6+）

### 2. 副本集状态检查 ⭐ **最重要**
- 检查是否配置了副本集
- 检查当前节点是否为主节点
- **如果未配置副本集，会显示错误信息和解决方案**

### 3. Oplog 状态检查
- 检查 oplog 是否可用
- 显示 oplog 记录数量
- 显示最新 oplog 时间戳

### 4. 用户权限检查
- 检查当前连接的用户认证信息
- 确认是否有足够权限

### 5. Change Stream 创建测试
- 实际测试创建 Change Stream 的能力
- 如果失败会显示可能的原因

## 日志输出示例

### 正常情况（副本集配置正确）
```json
{
  "level": "info",
  "msg": "开始检查 MongoDB 配置",
  "job_id": "mongodb-test",
  "time": "2025-06-20T10:51:05+08:00"
}

{
  "level": "info",
  "msg": "MongoDB 版本检查",
  "job_id": "mongodb-test",
  "version": "4.4.6",
  "time": "2025-06-20T10:51:05+08:00"
}

{
  "level": "info",
  "msg": "✅ MongoDB 副本集配置正常",
  "job_id": "mongodb-test",
  "set_name": "rs0",
  "is_primary": true,
  "time": "2025-06-20T10:51:05+08:00"
}

{
  "level": "info",
  "msg": "✅ Oplog 可用",
  "job_id": "mongodb-test",
  "oplog_count": 1234,
  "time": "2025-06-20T10:51:05+08:00"
}

{
  "level": "info",
  "msg": "✅ Change Stream 创建测试成功",
  "job_id": "mongodb-test",
  "time": "2025-06-20T10:51:05+08:00"
}
```

### 异常情况（未配置副本集）
```json
{
  "level": "error",
  "msg": "❌ MongoDB 未配置副本集 - 这是 Change Stream 不工作的根本原因！",
  "job_id": "mongodb-test",
  "time": "2025-06-20T10:51:05+08:00"
}

{
  "level": "error",
  "msg": "解决方案: 1) 停止MongoDB 2) 配置副本集 3) 重启MongoDB 4) 初始化副本集",
  "job_id": "mongodb-test",
  "time": "2025-06-20T10:51:05+08:00"
}

{
  "level": "error",
  "msg": "❌ Change Stream 创建测试失败",
  "job_id": "mongodb-test",
  "error": "change streams are only supported on replica sets",
  "time": "2025-06-20T10:51:05+08:00"
}
```

## 如何查看检测结果

### 1. 查看完整日志
```bash
tail -f ./consistent_sql.log
```

### 2. 只查看配置检测相关日志
```bash
tail -f ./consistent_sql.log | grep -E "(MongoDB.*配置|副本集|oplog|Change Stream.*测试)"
```

### 3. 查看错误信息
```bash
tail -f ./consistent_sql.log | grep -E "(❌|ERROR)"
```

### 4. 查看成功信息
```bash
tail -f ./consistent_sql.log | grep -E "(✅|INFO)"
```

## 解决副本集问题

如果检测到未配置副本集，按以下步骤解决：

### 1. 停止 MongoDB
```bash
sudo systemctl stop mongod
```

### 2. 修改配置文件
```bash
sudo nano /etc/mongod.conf
```

添加以下内容：
```yaml
replication:
  replSetName: "rs0"
```

### 3. 启动 MongoDB
```bash
sudo systemctl start mongod
```

### 4. 初始化副本集
```bash
mongo --eval "rs.initiate()"
```

### 5. 检查状态
```bash
mongo --eval "rs.status()"
```

### 6. 重新启动您的应用
重新启动应用后，配置检测应该显示副本集配置正常。

## 故障排除

### 如果仍然显示副本集问题
1. 检查 MongoDB 配置文件是否正确保存
2. 确认 MongoDB 服务已重启
3. 检查 MongoDB 日志：`sudo tail -f /var/log/mongodb/mongod.log`

### 如果 Change Stream 测试仍然失败
1. 确认 MongoDB 版本 >= 3.6
2. 确认副本集已正确初始化
3. 检查用户权限是否足够

## 注意事项

1. **配置检测会在每次启动 MongoDB 同步任务时自动运行**
2. **检测结果会记录在日志中，便于远程调试**
3. **如果检测到问题，会显示具体的解决方案**
4. **检测不会影响现有功能，只是增加了诊断信息**

这样您就可以在远程环境中直接通过日志查看 MongoDB 配置状态，快速定位 Change Stream 不工作的原因。
