#Welcome to Kunlun-storage database instance installation guide!

##Intro

Kunlun-storage originated from percona-server, currently it's based on percona-server-8.0.26. And it contains fixes to all known XA bugs in MySQL. Without such fixes, Kunlun distributed database cluster will not be crash safe and may lose committed transactions or be harmed by other serious data consistency errors, in the event of various hardware/software/network failures.

Kunlun-storage also contains features required by the computing node program of Kunlun distributed DBMS, and thus Kunlun Distributed Database Cluster requires the use of Kunlun-storage as meta data cluster and storage shards. Finally, we enhanced performance of XA transaction processing, and part of such enhancements are also in this community edition.

To achieve all above, we modified percona-server extensively --- including innodb, binlog recovery, binlog format, thread pool, etc. Despite of such enhancements, the data file format of kunlun-storage is exactly the same as community MySQL and data directory of a kunlun-storage can be used by community MySQL or percona-server, and vice versa. And percona xtrabackup can correctly backup a kunlun-storage data directory and restore it.

The only difference is that kunlun-storage's one binlog event(Previous_gtid_list) format is different from that of community MySQL or percona-server, so one needs to use the mysqlbinlog prgram released in kunlun-storage to decode binlog files produced by kunlun-storage.

We also maintain an enterprise edition of Kunlun distributed DBMS, which contains exclusively all performance enhancements in kunlun-storage and kunlun computing node software. Kunlun enterprise edition has identical functionality as this open source version. And they share the same data file format, WAL(redo) log file format, binlog events format, general log format, slow query log format, and mysqld log format. They also share the same metadata table format in both kunlun-storage and kunlun computing node. Consequently, the data directory of kunlun open source edition and kunlun enterprise edition can be used interchangably.

##Build from source

The same as community mysql or percona-server --- use cmake to configure it then do something like 'make install -j8'.

A typical cmake configuration we often use is as below. Note that we do use jemalloc, a shared object of prebuilt jemalloc is provided and is installed to each kunlun-storage db instance.

cmake .. -DCMAKE_BUILD_TYPE=Release -DWITH_DEBUG=0 -DCMAKE_INSTALL_PREFIX=<your installation directory> -DWITH_SSL=system -DWITH_BOOST=<your boost source root directory> -DWITH_KEYRING_VAULT=0 -DWITH_ZLIB=bundled -DWITH_TOKUDB=NO -DWITH_EDITLINE=bundled -DWITH_LOCK_ORDER=1 -DWITH_LSAN=0 -DWITH_MSAN=0 -DWITH_INNODB_EXTRA_DEBUG=0 -DWITH_ASAN=0 -DWITH_UBSAN=0 -DWITH_TSAN=0 -DWITH_JEMALLOC=0 -DWITH_ROUTER=0 -DWITH_FEDERATED_STORAGE_ENGINE=1 -DWITH_ARCHIVE_STORAGE_ENGINE=1 -DWITH_NGRAM_PARSER=1 -DWITHOUT_ROCKSDB=1  -DWITH_AUTHENTICATION_KERBEROS=0 -DWITH_AUTHENTICATION_LDAP=0 -DWITH_CURL=0 -DWITH_COREDUMPER=0

Then do 'make install -j4' to build kunlun-storage. You can use more processes than 4 if your computer has more cores.
Then in root source directory do 'bash post-install <your installation directory>'

##Library dependencies

If you are using a kunlun-storage program built from source on the same Linux distribution and version as where it's being used, simply skip this step because there is no dependency issues.

Normally all you have to do is to add Kunlun-storage/lib into LD_LIBRARY_PATH. And then if your mysqld can start up(run mysqld --version), then skip the rest of this section.

### Use dependent libraries
All dynamic shared objects (*.so files) that programs in Kunlun-storage/bin depend on, are provided in Kunlun-storage/lib/deps directory. Try startup mysqld (e.g. mysqld --version) and see if your local Linux distro needs any of the *.so files. If so, copy needed ones into Kunlun-storage/lib.

DO NOT copy everything in deps into lib at once, otherwise your linux OS or any software may not be able to work because of library version mismatches!

## Database Instance Installation

Use the ./dba_tools/install-mysql.py script to install an MGR node. To do so, one first needs to prepare an MGR cluster configuration file using the template in dba_tools/mgr_config.json. In this doc below the config file will be called 'my-shards.json'.

One should set the 'config' argument to the path of the MGR cluster configuration file.

One should set the 'target_node_index' argument of install-mysql.py to specify the target db instance to install. 'target_node_index' is the target db instance's array index in the 'nodes' array of my-shards.json. Note that one should always install the group replication primary node before installing any of its replicas, and make sure the primary node specified in config file is really currently the primary node of the MGR shard.

Then in Kunlun-storage/dba_tools directory, do below:
`python install-mysql.py --config=./my-shards.json --target_node_index=0`
There are other optional parameters to install-mysql.py, but they are not used for now or can be generated automatically except the 'dbcfg' argument, as detailed below.

To startup mysql server, use the convenient script 'startmysql.sh' in Kunlun-storage/dba_tools: ./startmysql.sh 3306
There are several other useful scripts in Kunlun-storage/dba_tools, use 'imysql.sh port' to connect to a db instance created by install-mysql.py; Use 'monitormysql.sh port' to see current QPS and other performance counters; Use 'stopmysql.sh port' to stop a mysqld server process.

### Alternative db instance config templates

There are multiple db instance config template files in ./dba_tools directory. Among them, ./dba_tools/template.cnf is the default if 'dbcfg' argument isn't specified in install-mysql.py execution, and is recommended for production kunlun-storage instances. Settings in ./dba_tools/template.cnf are premium for best performance, suitable for high performance mysql servers.

For the rest template files, the ./dba_tools/mysql-template.cnf is suitable for original mysql-8.0.x (x >=18) instances, and ./dba_tools/percona-template.cnf is suitable for original percona-mysql-8.0.x. Both of them originated from ./dba_tools/template.cnf, with unsupported arguments commented out and all other settings are the same as ./dba_tools/template.cnf.

And ./dba_tools/template-small.cnf is suitable for Kunlun-storage instances with trivial resource consumption, e.g. developers can use it for Kunlun cluster installation testing. One could use another template file as necessary for other purposes.

If one needs other config templates than ./dba_tools/template.cnf, specifiy the 'dbcfg' argument. For example when you have an binary installation of original mysql-8.0.x or a percona-mysql-8.0.x-y, you can copy the Kunlun-storage/dba_tools directory into that installation's root directory, in order to make use of the installation scripts and config templates. And you can create another template file and use it to create db instances as below example.

e.g. `python install-mysql.py --config=./mgr_config0.json --target_node_index=0 --dbcfg=./mysql-template-small.cnf`

### Shard Config File Explained

{
    "group_uuid":"e6578c3a-547e-11ea-9780-981fd1bd410d",	# mgr group uuid. should be unique in a Kunlun cluster for best readability.
    "nodes":						#each node contains configs of a db instance.
    [
       {
          "is_primary":true,				# whether this db instance is a primary node. there must be one and only one primary node in the 'nodes' array.
          "ip": "127.0.0.1",				# ip address to listen on, bind_address and report_host are set to this ip.
          "port": 6001,					# regular listen port
          "xport": 60010,				# mysql X protocol listen port
          "mgr_port": 60011,				# port for mgr communication between an MGR group. not used by clients.
          "innodb_buffer_pool_size":"64MB",		# innodb buffer pool size
		  "innodb_log_dir_path":"/data1/innodb-logs # Innodb WAL logs are stored here.
          "data_dir_path":"/data",			# innodb data files are stored here
          "log_dir_path":"/data2/log",			# binlogs and mysqld.err are stored in this path.
          "user":"abc",					# A valid OS user name, the created db instance's all data/log dirs/files will be owned by this user.
          "election_weight":50				# mgr primary election weight. don't modify it without reading the relevant doc first.
       }
	, more shard node (db instance) config objects
    ]
}


