#!/usr/bin/env python2
import shutil
import sys
import random
import argparse
import os
import subprocess
def read_file_as_str(file_path):
    if not os.path.isfile(file_path):
        raise TypeError(file_path + " does not exist")

    all_the_text = open(file_path).read()
    # print(type(all_the_text))
    return all_the_text.strip()

def confirmStopSuccess(args):
    # data_dir = os.path.abspath(args.datadir_prefix) + "/" + str(args.port)
    log_dir = os.path.abspath(args.logdir_prefix) + "/" + str(args.port)
    pidfile = "{dt}/mysql.pid".format(dt=log_dir)
    mysqld_pid = ""
    try:
        mysqld_pid = read_file_as_str(pidfile)
    except TypeError as err:
        sys.stderr.write("read pid file error:{}".format(str(err)))
        exit(1);
    process_dir = os.path.join('/proc',str(mysqld_pid))
    return os.path.exists(process_dir)

def doKill(args):
   # data_dir = os.path.abspath(args.datadir_prefix) + "/" + str(args.port)
    log_dir = os.path.abspath(args.logdir_prefix) + "/" + str(args.port)
    pidfile = "{dt}/mysql.pid".format(dt = log_dir)
    mysqld_pid = ""
    try:
        mysqld_pid = read_file_as_str(pidfile)
    except TypeError as err:
        sys.stderr.write("read pid file error:{}".format(str(err)))
        return 

    # fetch mysqld_safe pid
    cmd0 = "ps -ef| grep {md_pid}| grep -v grep | grep mysqld ".format(md_pid = mysqld_pid)
    print(cmd0)
    try:
        output = subprocess.check_output(cmd0,shell=True)
        print(output);
    except subprocess.CalledProcessError as e:
        return
    cmd = "ps -ef| grep {md_pid}| grep mysqld | grep -v grep| awk -F\" \" '{{printf $2 \" \" $3}}' | xargs kill -9".format(md_pid = mysqld_pid)
    print(cmd)
    os.system(cmd)



def rollback_installation(args):
    error_count = 0
    workpath = "{prefix}/{pt}/{prgname}".format(
        prefix=os.path.abspath(args.install_prefix), pt=str(args.port), prgname=str(args.prog_name)
    )
    dba_tools_path = "{wp}/dba_tools".format(wp=workpath)

    # 1. Stop MySQL instance if already running by invoking stop_mysql.sh
    #cmd_stop_mysql = "cd {dp};sh ./stopmysql.sh {port}".format(dp=dba_tools_path,port=str(args.port))
    #try:
    #    os.system(cmd_stop_mysql)
    #except OSError as err:
    #    sys.stderr.write("Stop MySQL instance failed: {}".format(str(err)))
    #    error_count = error_count +1;
    doKill(args)

    # 2. remove the related directory
    try:
        # 1.1 remove the MySQL binary residential directory
        runing_dir = os.path.abspath(args.install_prefix) + "/" + str(args.port)
        shutil.rmtree(runing_dir,ignore_errors=True)

        # 1.2 remove the MySQL data residential directory
        data_dir = os.path.abspath(args.datadir_prefix) + "/" + str(args.port)
        shutil.rmtree(data_dir,ignore_errors=True)

        # 1.3 remove the MySQL log residential directory
        log_dir = os.path.abspath(args.logdir_prefix) + "/" + str(args.port)
        shutil.rmtree(log_dir,ignore_errors=True)

        # 1.4 remove the MySQL wal log residential directory
        wallog_dir = os.path.abspath(args.waldir_prefix) + "/" + str(args.port)
        shutil.rmtree(wallog_dir,ignore_errors=True)

    except OSError as err:
        sys.stderr.write("Remove the Instance data and log failed: {}".format(str(err)))
        error_count = error_count+1

    if error_count > 0:
      return False

    return True


if __name__ == "__main__":
    random.seed(str(sys.argv[1:]))
    parser = argparse.ArgumentParser(description="Install the MySQL Instance.")
    parser.add_argument("--user", type=str, help="MySQL install user", required=True)
    parser.add_argument(
        "--port", type=int, help="MySQL Instance Lisening port", required=True
    )
    parser.add_argument(
        "--bind_address", type=str, help="MySQL Instance binding address", required=True
    )
    parser.add_argument(
        "--innodb_buffer_poll_size_M",
        type=int,
        help="INNODB buffer poll size in xx M",
        required=False,
    )
    parser.add_argument(
        "--datadir_prefix",
        type=str,
        help="data directory prefix",
        default="",
        required=True,
    )
    parser.add_argument(
        "--logdir_prefix",
        type=str,
        help="log directory prefix",
        required=True,
    )
    parser.add_argument(
        "--waldir_prefix", type=str, help="redo log directory prefix", required=True
    )
    parser.add_argument(
        "--install_prefix",
        type=str,
        help="MySQL installation directory prefix",
        required=True,
    )
    parser.add_argument(
        "--prog_name",
        type=str,
        help="MySQL pakage name",
        required=True,
    )
    args = parser.parse_args()

    ret = rollback_installation(args)

    if ret == False:
      exit(1)

    exit(0)
