/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.ExecutionPlan;
import org.postgresql.pljava.internal.TupleDesc;

public class Portal {
    private ExecutionPlan m_plan;
    private final State m_state;

    Portal(DualState.Key cookie, long ro, long pointer, ExecutionPlan plan) {
        this.m_state = new State(cookie, this, ro, pointer);
        this.m_plan = plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            this.m_state.releaseFromJava();
            this.m_plan = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Portal._getName(this.m_state.getPortalPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPortalPos() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long pos = Portal._getPortalPos(this.m_state.getPortalPtr());
            if (pos < 0L) {
                throw new ArithmeticException("portal position too large to report in a Java signed long");
            }
            return pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleDesc getTupleDesc() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Portal._getTupleDesc(this.m_state.getPortalPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fetch(boolean forward, long count) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long fetched = Portal._fetch(this.m_state.getPortalPtr(), forward, count);
            if (fetched < 0L) {
                throw new ArithmeticException("fetched too many rows to report in a Java signed long");
            }
            return fetched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAtEnd() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Portal._isAtEnd(this.m_state.getPortalPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAtStart() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Portal._isAtStart(this.m_state.getPortalPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long move(boolean forward, long count) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long moved = Portal._move(this.m_state.getPortalPtr(), forward, count);
            if (moved < 0L) {
                throw new ArithmeticException("moved too many rows to report in a Java signed long");
            }
            return moved;
        }
    }

    private static native String _getName(long var0) throws SQLException;

    private static native long _getPortalPos(long var0) throws SQLException;

    private static native TupleDesc _getTupleDesc(long var0) throws SQLException;

    private static native long _fetch(long var0, boolean var2, long var3) throws SQLException;

    private static native void _close(long var0);

    private static native boolean _isAtEnd(long var0) throws SQLException;

    private static native boolean _isAtStart(long var0) throws SQLException;

    private static native long _move(long var0, boolean var2, long var3) throws SQLException;

    private static class State
    extends DualState.SingleSPIcursorClose<Portal> {
        private State(DualState.Key cookie, Portal referent, long ro, long portal) {
            super(cookie, referent, ro, portal);
        }

        private long getPortalPtr() throws SQLException {
            this.pin();
            try {
                long l = this.guardedLong();
                return l;
            }
            finally {
                this.unpin();
            }
        }
    }
}

