/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.postgresql.pljava.SavepointListener;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.PgSavepoint;

class SubXactListener {
    private static final Deque<SavepointListener> s_listeners = new ArrayDeque<SavepointListener>();

    SubXactListener() {
    }

    static void onAbort(PgSavepoint sp, PgSavepoint parent) throws SQLException {
        for (SavepointListener listener : s_listeners.toArray(new SavepointListener[s_listeners.size()])) {
            listener.onAbort(Backend.getSession(), sp, parent);
        }
    }

    static void onCommit(PgSavepoint sp, PgSavepoint parent) throws SQLException {
        for (SavepointListener listener : s_listeners.toArray(new SavepointListener[s_listeners.size()])) {
            listener.onCommit(Backend.getSession(), sp, parent);
        }
    }

    static void onStart(PgSavepoint sp, PgSavepoint parent) throws SQLException {
        for (SavepointListener listener : s_listeners.toArray(new SavepointListener[s_listeners.size()])) {
            listener.onStart(Backend.getSession(), sp, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(SavepointListener listener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (s_listeners.contains(listener)) {
                return;
            }
            s_listeners.push(listener);
            if (1 == s_listeners.size()) {
                SubXactListener._register();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListener(SavepointListener listener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (!s_listeners.remove(listener)) {
                return;
            }
            if (0 == s_listeners.size()) {
                SubXactListener._unregister();
            }
        }
    }

    private static native void _register();

    private static native void _unregister();
}

