/*-------------------------------------------------------------------------
 *
 * mysql_conn_priv.h
 *		Kunlun Database MySQL protocol server side implementation.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/mysql_conn_priv.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef VIO_PRIV_INCLUDED
#define VIO_PRIV_INCLUDED

#define DONT_MAP_VIRTIO
#include "libmysql/mysql_com.h"

#include "libmysql/string_utils.h"
#include "libmysql/mysql_conn.h"


extern bool virtio_buff_has_data(MySQLConn *myconn);
extern int virtio_socket_io_wait(MySQLConn *myconn, enum enum_virtio_io_event event);
extern int virtio_socket_timeout(MySQLConn *myconn, unsigned int which, bool old_mode);
extern size_t virtio_ssl_read(MySQLConn *myconn, unsigned char *buf, size_t size);
extern size_t virtio_ssl_write(MySQLConn *myconn, const unsigned char *buf, size_t size);
/* When the workday is over... */
extern int virtio_ssl_shutdown(MySQLConn *myconn, int how);
extern void virtio_ssl_delete(MySQLConn *myconn);
extern bool virtio_ssl_has_data(MySQLConn *myconn);

#endif /* VIO_PRIV_INCLUDED */
