/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import java.util.Collection;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIQualifiedObject;
import org.jkiss.wmi.service.WMIQualifier;

public abstract class WMIPropertySource
implements DBPPropertySource {
    private static final Log log = Log.getLog(WMIPropertySource.class);
    private static final DBPPropertyDescriptor[] EMPTY_PROPERTIES = new DBPPropertyDescriptor[0];

    protected abstract WMIQualifiedObject getQualifiedObject();

    protected boolean getFlagQualifier(String qName) throws DBException {
        WMIQualifiedObject qualifiedObject = this.getQualifiedObject();
        try {
            return qualifiedObject != null && Boolean.TRUE.equals(qualifiedObject.getQualifier(qName));
        }
        catch (WMIException e) {
            throw new DBException("Can't extract object qualifiers", (Throwable)e);
        }
    }

    public Object getEditableValue() {
        return this;
    }

    public DBPPropertyDescriptor[] getProperties() {
        try {
            WMIQualifiedObject qualifiedObject = this.getQualifiedObject();
            if (qualifiedObject == null) {
                return EMPTY_PROPERTIES;
            }
            Collection<WMIQualifier> qualifiers = qualifiedObject.getQualifiers();
            DBPPropertyDescriptor[] result = new DBPPropertyDescriptor[qualifiers.size()];
            int index = 0;
            for (WMIQualifier qualifier : qualifiers) {
                String name = qualifier.getName();
                PropertyDescriptor prop = new PropertyDescriptor("WMI", name, name, null, null, false, null, null, false);
                result[index++] = prop;
            }
            return result;
        }
        catch (WMIException e) {
            log.error((Object)e);
            return EMPTY_PROPERTIES;
        }
    }

    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, String id) {
        try {
            return this.getQualifiedObject().getQualifier(id.toString());
        }
        catch (WMIException e) {
            log.error((Object)e);
            return null;
        }
    }

    public boolean isPropertySet(String id) {
        try {
            return this.getQualifiedObject().getQualifier(id.toString()) != null;
        }
        catch (WMIException e) {
            log.error((Object)e);
            return false;
        }
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, String id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, String id, Object value) {
    }

    public boolean isPropertyResettable(String id) {
        return false;
    }

    public void resetPropertyValueToDefault(String id) {
    }
}

